/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.BWGPlacementBushBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.DesertPlantBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.FlowerableBushBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.FloweringBushBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.ShrubBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.cactus.BWGCactusBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.BWGDoublePlantBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.vegetation.FlatVegetationBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;
import org.apache.logging.log4j.util.TriConsumer;

public class BlockFeatures {
    public static void registerCompostables(BiConsumer<ItemLike, Float> consumer) {
        BWGBlocks.BLOCKS.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)object -> {
            Block block = (Block)object.get();
            if (block instanceof TallGrassBlock || block instanceof BWGDoublePlantBlock || block instanceof PinkPetalsBlock) {
                consumer.accept((ItemLike)block, Float.valueOf(0.3f));
            } else if (block instanceof VineBlock || block instanceof DesertPlantBlock || block instanceof BWGCactusBlock) {
                consumer.accept((ItemLike)block, Float.valueOf(0.5f));
            } else if (block instanceof FlowerBlock || block instanceof TallFlowerBlock || block instanceof WaterlilyBlock || block instanceof MushroomBlock || block instanceof FlatVegetationBlock || block instanceof BWGPlacementBushBlock || block instanceof PumpkinBlock || block instanceof CarvedPumpkinBlock || block instanceof SporeBlossomBlock) {
                consumer.accept((ItemLike)block, Float.valueOf(0.65f));
            } else if (block instanceof HugeMushroomBlock || block instanceof HayBlock) {
                consumer.accept((ItemLike)block, Float.valueOf(0.85f));
            }
        }));
        BlockFeatures.compostItems(consumer, 0.4f, (ItemLike)BWGBlocks.CATTAIL_THATCH_SLAB.get(), (ItemLike)BWGBlocks.CATTAIL_THATCH_STAIRS.get(), (ItemLike)BWGBlocks.CATTAIL_THATCH_CARPET.get());
        BWGWood.WOOD.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            if (entry.get() instanceof LeavesBlock || entry.get() instanceof SaplingBlock || entry.get() instanceof MangroveRootsBlock) {
                consumer.accept((ItemLike)entry.get(), Float.valueOf(0.3f));
            }
        }));
        BlockFeatures.compostItems(consumer, 0.85f, (ItemLike)BWGBlocks.CYAN_PITCHER_PLANT.get(), (ItemLike)BWGBlocks.MAGENTA_PITCHER_PLANT.get());
        BlockFeatures.compostItems(consumer, 0.3f, (ItemLike)BWGItems.PALE_PUMPKIN_SEEDS.get(), (ItemLike)BWGItems.BLUEBERRIES.get(), (ItemLike)BWGBlocks.WITCH_HAZEL_BRANCH.get());
        BlockFeatures.compostItems(consumer, 0.5f, (ItemLike)BWGItems.BLUE_GLOWCANE_SHOOT.get(), (ItemLike)BWGItems.GREEN_GLOWCANE_SHOOT.get(), (ItemLike)BWGItems.RED_GLOWCANE_SHOOT.get(), (ItemLike)BWGItems.YELLOW_GLOWCANE_SHOOT.get(), (ItemLike)BWGItems.CATTAIL_SPROUT.get(), (ItemLike)BWGItems.FLUORESCENT_CATTAIL_SPROUT.get());
        BlockFeatures.compostItems(consumer, 0.65f, (ItemLike)BWGItems.GREEN_APPLE.get(), (ItemLike)BWGItems.BAOBAB_FRUIT.get(), (ItemLike)BWGItems.SOUL_FRUIT.get(), (ItemLike)BWGItems.YUCCA_FRUIT.get(), (ItemLike)BWGItems.ODDION_BULB.get(), (ItemLike)BWGItems.WHITE_PUFFBALL_SPORES.get(), (ItemLike)BWGItems.WHITE_PUFFBALL_CAP.get());
        BlockFeatures.compostItems(consumer, 0.75f, (ItemLike)BWGItems.COOKED_YUCCA_FRUIT.get(), (ItemLike)BWGItems.COOKED_ODDION_BULB.get(), (ItemLike)BWGItems.COOKED_WHITE_PUFFBALL_CAP.get(), (ItemLike)BWGItems.WREATH.get(), (ItemLike)BWGItems.HOLLY_WREATH.get(), (ItemLike)BWGItems.PETAL_WREATH.get(), (ItemLike)BWGItems.ROSY_WREATH.get(), (ItemLike)BWGItems.WINTER_ROSY_WREATH.get(), (ItemLike)BWGItems.ODDION_WREATH.get(), (ItemLike)BWGItems.MUSHROOM_WREATH.get());
        BlockFeatures.compostItems(consumer, 1.0f, (ItemLike)BWGItems.GREEN_APPLE_PIE.get(), (ItemLike)BWGItems.BLUEBERRY_PIE.get());
    }

    private static void compostItems(BiConsumer<ItemLike, Float> consumer, float chance, ItemLike ... items) {
        for (ItemLike item : items) {
            consumer.accept(item, Float.valueOf(chance));
        }
    }

    public static void registerFlammable(TriConsumer<Block, Integer, Integer> consumer) {
        BWGWoodSet.woodsets().forEach(set -> {
            consumer.accept((Object)set.planks(), (Object)5, (Object)20);
            consumer.accept((Object)set.slab(), (Object)5, (Object)20);
            consumer.accept((Object)set.stairs(), (Object)5, (Object)20);
            consumer.accept((Object)set.fence(), (Object)5, (Object)20);
            consumer.accept((Object)set.fenceGate(), (Object)5, (Object)20);
            consumer.accept((Object)set.logstem(), (Object)5, (Object)5);
            consumer.accept((Object)set.strippedLogStem(), (Object)5, (Object)5);
            consumer.accept((Object)set.wood(), (Object)5, (Object)5);
            consumer.accept((Object)set.strippedWood(), (Object)5, (Object)5);
            consumer.accept((Object)set.bookshelf(), (Object)30, (Object)20);
        });
        BWGWood.WOOD.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)block -> {
            if (block.get() instanceof LeavesBlock) {
                consumer.accept((Object)((Block)block.get()), (Object)30, (Object)60);
            } else if (block.get() instanceof MangroveRootsBlock) {
                consumer.accept((Object)((Block)block.get()), (Object)5, (Object)20);
            }
        }));
        consumer.accept((Object)((Block)BWGWood.PALO_VERDE_LOG.get()), (Object)5, (Object)5);
        consumer.accept((Object)((Block)BWGWood.STRIPPED_PALO_VERDE_LOG.get()), (Object)5, (Object)5);
        consumer.accept((Object)((Block)BWGWood.PALO_VERDE_WOOD.get()), (Object)5, (Object)5);
        consumer.accept((Object)((Block)BWGWood.STRIPPED_PALO_VERDE_WOOD.get()), (Object)5, (Object)5);
        consumer.accept((Object)((Block)BWGWood.IMBUED_BLUE_ENCHANTED_WOOD.get()), (Object)5, (Object)5);
        consumer.accept((Object)((Block)BWGWood.IMBUED_GREEN_ENCHANTED_WOOD.get()), (Object)5, (Object)5);
        BWGBlocks.BLOCKS.forEach((Consumer<Supplier<? extends Block>>)((Consumer<Supplier>)entry -> {
            Block block = (Block)entry.get();
            if (block instanceof LeavesBlock) {
                consumer.accept((Object)block, (Object)30, (Object)60);
            } else if (block instanceof SweetBerryBushBlock || block instanceof FlowerBlock || block instanceof TallFlowerBlock || block instanceof TallGrassBlock || block instanceof PinkPetalsBlock || block instanceof FlatVegetationBlock || block instanceof SporeBlossomBlock) {
                consumer.accept((Object)block, (Object)60, (Object)100);
            } else if (block instanceof FloweringBushBlock || block instanceof FlowerableBushBlock || block instanceof ShrubBlock || block instanceof VineBlock) {
                consumer.accept((Object)block, (Object)15, (Object)100);
            }
        }));
        consumer.accept((Object)((Block)BWGBlocks.HYDRANGEA_HEDGE.get()), (Object)60, (Object)100);
        consumer.accept((Object)BWGBlocks.HYDRANGEA_BUSH.getBlock(), (Object)60, (Object)100);
        consumer.accept((Object)((Block)BWGBlocks.CATTAIL_THATCH.get()), (Object)60, (Object)20);
        consumer.accept((Object)((Block)BWGBlocks.CATTAIL_THATCH_SLAB.get()), (Object)60, (Object)20);
        consumer.accept((Object)((Block)BWGBlocks.CATTAIL_THATCH_STAIRS.get()), (Object)60, (Object)20);
        consumer.accept((Object)((Block)BWGBlocks.CATTAIL_THATCH_CARPET.get()), (Object)60, (Object)20);
        consumer.accept((Object)((Block)BWGBlocks.WITCH_HAZEL_BRANCH.get()), (Object)30, (Object)60);
    }

    public static void registerFurnaceFuels(BiConsumer<ItemLike, Integer> consumer) {
        consumer.accept((ItemLike)BWGBlocks.PEAT.get().asItem(), 1200);
        consumer.accept((ItemLike)BWGBlocks.CATTAIL_THATCH.get().asItem(), 300);
        consumer.accept((ItemLike)BWGBlocks.CATTAIL_THATCH_SLAB.get().asItem(), 150);
        consumer.accept((ItemLike)BWGBlocks.CATTAIL_THATCH_STAIRS.get().asItem(), 300);
        consumer.accept((ItemLike)BWGWood.SPIRIT_ROOTS.get(), 300);
        BWGWoodSet.woodsets().forEach(bwgWoodSet -> {
            consumer.accept((ItemLike)bwgWoodSet.bookshelf(), 300);
            consumer.accept((ItemLike)bwgWoodSet.craftingTable(), 300);
        });
        consumer.accept((ItemLike)BWGBlocks.FORAGERS_TABLE.get(), 300);
        consumer.accept((ItemLike)BWGBlocks.WITCH_HAZEL_BRANCH.get().asItem(), 100);
    }
}

