/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.compat.wthit;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.PairComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.BWGBerryBush;

enum BWGPlantProvider implements IBlockComponentProvider
{
    INSTANCE;


    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.addLine((ITooltipComponent)new PairComponent((Component)Component.translatable((String)"tooltip.waila.crop_growth"), (Component)Component.literal((String)String.format("%.0f%%", Float.valueOf(growthValue)))));
        } else {
            tooltip.addLine((ITooltipComponent)new PairComponent((Component)Component.translatable((String)"tooltip.waila.crop_growth"), (Component)Component.translatable((String)"tooltip.waila.crop_mature")));
        }
    }

    private static void addGrowableTooltip(ITooltip tooltip, ResourceLocation tag, String translationKey, boolean growable) {
        tooltip.setLine(tag, (ITooltipComponent)new PairComponent((Component)Component.translatable((String)translationKey), (Component)(growable ? Component.translatable((String)"tooltip.waila.true") : Component.translatable((String)"tooltip.waila.false"))));
    }

    private static void addCropGrowableTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        int lightLevel = accessor.getWorld().getRawBrightness(accessor.getPosition(), 0);
        BWGPlantProvider.addGrowableTooltip(tooltip, ResourceLocation.withDefaultNamespace((String)"plant.crop_growable"), "tooltip.waila.crop_growable", lightLevel >= 9);
    }

    private static void addTreeGrowableTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        int lightLevel = accessor.getWorld().getRawBrightness(accessor.getPosition(), 0);
        BWGPlantProvider.addGrowableTooltip(tooltip, ResourceLocation.withDefaultNamespace((String)"plant.tree_growable"), "tooltip.waila.tree_growable", lightLevel >= 9);
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        if (!IModInfo.get((Block)block).getId().equals("biomeswevegone")) {
            return;
        }
        BlockState state = accessor.getBlockState();
        if (config.getBoolean(ResourceLocation.withDefaultNamespace((String)"plant.crop_progress"))) {
            if (block instanceof BWGBerryBush) {
                BWGPlantProvider.addMaturityTooltip(tooltip, (float)((Integer)state.getValue((Property)BWGBerryBush.AGE)).intValue() / 3.0f);
            } else if (block instanceof StemBlock) {
                BWGPlantProvider.addMaturityTooltip(tooltip, (float)((Integer)state.getValue((Property)StemBlock.AGE)).intValue() / 7.0f);
            }
        }
        if (config.getBoolean(ResourceLocation.withDefaultNamespace((String)"plant.crop_growable")) && (block instanceof CropBlock || block instanceof StemBlock)) {
            BWGPlantProvider.addCropGrowableTooltip(tooltip, accessor);
        }
        if (config.getBoolean(ResourceLocation.withDefaultNamespace((String)"plant.tree_growable")) && block instanceof SaplingBlock) {
            BWGPlantProvider.addTreeGrowableTooltip(tooltip, accessor);
        }
    }
}

