/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.ricmc.betterblockz.block.custom.FlatBarLightBlock;
import net.ricmc.betterblockz.block.custom.FlatBarLightVerticalBlock;
import net.ricmc.betterblockz.block.custom.LightPanelBlock;
import net.ricmc.betterblockz.block.custom.RotatableBlock;
import net.ricmc.betterblockz.block.custom.WallOrFloorLightBlock;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class AutoPlacerItem
extends Item {
    private static final Map<PlayerHandKey, List<PlacedEntry>> lastPlaced = new HashMap<PlayerHandKey, List<PlacedEntry>>();

    public AutoPlacerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        if (player == null || level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Block clickedBlock = level.getBlockState(pos).getBlock();
        BlockState clickedState = level.getBlockState(pos);
        PlayerHandKey key = new PlayerHandKey(player.getUUID(), context.getHand());
        if (player.isShiftKeyDown()) {
            boolean clickedIsPlaced;
            boolean hasUndo = lastPlaced.containsKey(key) && !lastPlaced.get(key).isEmpty();
            boolean bl = clickedIsPlaced = hasUndo && lastPlaced.get(key).stream().anyMatch(entry -> entry.getPos().equals((Object)pos) && level.getBlockState(pos).is(entry.getPlacedBlock()));
            if (clickedIsPlaced) {
                List<PlacedEntry> placedList = lastPlaced.get(key);
                int returned = 0;
                int refundable = (Integer)stack.getOrDefault(ModDataComponents.CONSUMED_COUNT, (Object)0);
                for (PlacedEntry entry2 : placedList) {
                    BlockState current = level.getBlockState(entry2.getPos());
                    if (!current.is(entry2.getPlacedBlock())) continue;
                    level.setBlockAndUpdate(entry2.getPos(), entry2.getPrevious());
                    if (player.isCreative() || refundable <= 0 || !entry2.getPrevious().isAir()) continue;
                    ItemStack returnStack = new ItemStack((ItemLike)entry2.getPlacedBlock());
                    if (!player.getInventory().add(returnStack)) {
                        player.drop(returnStack, false);
                    }
                    --refundable;
                    ++returned;
                }
                stack.remove(ModDataComponents.CONSUMED_COUNT);
                lastPlaced.remove(key);
                player.sendSystemMessage((Component)Component.literal((String)("Undid last placement!" + (String)(player.isCreative() ? " " : " Returned " + returned + " blocks."))));
                level.playSound(null, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                stack.set(ModDataComponents.STORED_BLOCK, (Object)BuiltInRegistries.BLOCK.getKey((Object)clickedBlock));
                if (clickedBlock instanceof RotatedPillarBlock && clickedState.hasProperty((Property)RotatedPillarBlock.AXIS)) {
                    stack.set(ModDataComponents.STORED_AXIS, (Object)((Direction.Axis)clickedState.getValue((Property)RotatedPillarBlock.AXIS)).getName());
                } else {
                    stack.remove(ModDataComponents.STORED_AXIS);
                }
                if (clickedState.getProperties().stream().anyMatch(p -> p.getName().equals("facing"))) {
                    facing = (Direction)clickedState.getValue(clickedState.getProperties().stream().filter(p -> p.getName().equals("facing")).findFirst().get());
                    stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
                } else if (clickedState.getProperties().stream().anyMatch(p -> p.getName().equals("horizontal_facing"))) {
                    facing = (Direction)clickedState.getValue(clickedState.getProperties().stream().filter(p -> p.getName().equals("horizontal_facing")).findFirst().get());
                    stack.set(ModDataComponents.STORED_FACING, (Object)facing.getName());
                } else {
                    stack.remove(ModDataComponents.STORED_FACING);
                }
                int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
                int size = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_SIZE)).orElse(3);
                Object modeName = mode == 0 ? "Area Mode " + (size == 3 ? "7x7" : "21x21") : (mode == 1 ? "Line Mode " + (size == 3 ? "7 blocks" : "21 blocks") : "Unknown Mode");
                player.displayClientMessage((Component)Component.literal((String)("Saved block type: " + clickedBlock.getName().getString() + " (" + (String)modeName + ")")), true);
                level.playSound(null, pos, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.CONSUME;
        }
        if (stack.get(ModDataComponents.STORED_BLOCK) == null) {
            player.displayClientMessage((Component)Component.literal((String)"No block saved! Sneak + right-click a block first."), true);
            return InteractionResult.FAIL;
        }
        Block blockToPlace = (Block)BuiltInRegistries.BLOCK.get((ResourceLocation)stack.get(ModDataComponents.STORED_BLOCK));
        if (blockToPlace == null) {
            return InteractionResult.FAIL;
        }
        int radius = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_SIZE)).orElse(3);
        int mode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
        ArrayList<BlockPos> emptyPositions = new ArrayList<BlockPos>();
        if (mode == 0) {
            if (face == Direction.UP || face == Direction.DOWN) {
                Direction forward = player.getDirection();
                Direction right = forward.getClockWise();
                int height = face == Direction.UP ? 1 : -1;
                for (dx = 0; dx < radius * 2 + 1; ++dx) {
                    for (int dz = 0; dz < radius * 2 + 1; ++dz) {
                        offsetPos = pos.relative(right, dx).relative(forward, dz).above(height);
                        if (!level.isEmptyBlock(offsetPos)) continue;
                        emptyPositions.add(offsetPos);
                    }
                }
            } else {
                Direction widthDir = face.getCounterClockWise();
                Direction heightDir = Direction.UP;
                BlockPos startPos = pos.relative(face);
                for (dx = 0; dx < radius * 2 + 1; ++dx) {
                    for (int dy = 0; dy < radius * 2 + 1; ++dy) {
                        offsetPos = startPos.relative(widthDir, dx).relative(heightDir, dy);
                        if (!level.isEmptyBlock(offsetPos)) continue;
                        emptyPositions.add(offsetPos);
                    }
                }
            }
        } else if (mode == 1) {
            int length = radius == 3 ? 7 : 21;
            BlockPos startPos = pos.relative(face);
            Direction lineDir = face.getAxis().isHorizontal() ? (player.getViewXRot(1.0f) < -30.0f ? Direction.UP : (player.getViewXRot(1.0f) > 30.0f ? Direction.DOWN : player.getDirection().getCounterClockWise())) : player.getDirection();
            for (int i = 0; i < length; ++i) {
                BlockPos offsetPos = startPos.relative(lineDir, i);
                if (!level.isEmptyBlock(offsetPos)) continue;
                emptyPositions.add(offsetPos);
            }
        }
        ArrayList<PlacedEntry> placed = new ArrayList<PlacedEntry>();
        int consumed = 0;
        for (BlockPos targetPos : emptyPositions) {
            String storedFacing;
            boolean canPlace = player.isCreative() || this.removeBlockFromInventory(player, blockToPlace);
            if (!canPlace) continue;
            if (!player.isCreative()) {
                ++consumed;
            }
            BlockState previous = level.getBlockState(targetPos);
            Direction targetFace = face;
            Vec3 hitVec = Vec3.atCenterOf((Vec3i)targetPos);
            BlockState newState = blockToPlace.getStateForPlacement(new BlockPlaceContext(player, context.getHand(), stack, new BlockHitResult(hitVec, targetFace, targetPos, false)));
            if (newState == null) {
                newState = blockToPlace.defaultBlockState();
            }
            if (blockToPlace instanceof WallOrFloorLightBlock) {
                WallOrFloorLightBlock wf = (WallOrFloorLightBlock)blockToPlace;
                newState = face.getAxis().isHorizontal() ? (BlockState)newState.setValue((Property)WallOrFloorLightBlock.FACING, (Comparable)face) : (BlockState)newState.setValue((Property)WallOrFloorLightBlock.FACING, (Comparable)(face == Direction.UP ? Direction.UP : Direction.DOWN));
            } else if (blockToPlace instanceof LightPanelBlock) {
                LightPanelBlock lp = (LightPanelBlock)blockToPlace;
                newState = face.getAxis().isHorizontal() ? (BlockState)newState.setValue((Property)LightPanelBlock.FACING, (Comparable)face) : (BlockState)newState.setValue((Property)LightPanelBlock.FACING, (Comparable)(face == Direction.UP ? Direction.UP : Direction.DOWN));
            } else if (blockToPlace instanceof FlatBarLightBlock) {
                FlatBarLightBlock lp = (FlatBarLightBlock)blockToPlace;
                newState = face.getAxis().isHorizontal() ? (BlockState)newState.setValue((Property)FlatBarLightBlock.FACING, (Comparable)face) : (BlockState)newState.setValue((Property)FlatBarLightBlock.FACING, (Comparable)(face == Direction.UP ? Direction.UP : Direction.DOWN));
            } else if (blockToPlace instanceof FlatBarLightVerticalBlock) {
                FlatBarLightVerticalBlock lp = (FlatBarLightVerticalBlock)blockToPlace;
                newState = face.getAxis().isHorizontal() ? (BlockState)newState.setValue((Property)FlatBarLightVerticalBlock.FACING, (Comparable)face) : (BlockState)newState.setValue((Property)FlatBarLightVerticalBlock.FACING, (Comparable)(face == Direction.UP ? Direction.UP : Direction.DOWN));
            }
            if (blockToPlace instanceof RotatedPillarBlock) {
                String storedAxis = (String)stack.get(ModDataComponents.STORED_AXIS);
                if (storedAxis != null) {
                    try {
                        newState = (BlockState)newState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.byName((String)storedAxis));
                    }
                    catch (Exception lp) {}
                } else if (clickedBlock instanceof RotatedPillarBlock) {
                    newState = (BlockState)newState.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)clickedState.getValue((Property)RotatedPillarBlock.AXIS)));
                }
            }
            if (blockToPlace instanceof RotatableBlock && (storedFacing = (String)stack.get(ModDataComponents.STORED_FACING)) != null) {
                try {
                    Direction dir = Direction.byName((String)storedFacing);
                    if (dir != null && newState.hasProperty((Property)RotatableBlock.FACING)) {
                        newState = (BlockState)newState.setValue((Property)RotatableBlock.FACING, (Comparable)dir);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            level.setBlockAndUpdate(targetPos, newState);
            placed.add(new PlacedEntry(targetPos, previous, blockToPlace));
        }
        if (!placed.isEmpty()) {
            lastPlaced.remove(key);
            lastPlaced.put(key, placed);
            stack.set(ModDataComponents.CONSUMED_COUNT, (Object)consumed);
            if (!player.isCreative()) {
                if (consumed == 0) {
                    player.displayClientMessage((Component)Component.literal((String)("You don't have any " + blockToPlace.getName().getString() + " in your inventory!")), true);
                } else if (consumed < emptyPositions.size()) {
                    player.displayClientMessage((Component)Component.literal((String)("Placed " + consumed + " blocks, out of inventory.")), true);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)("Placed " + consumed + " blocks.")), true);
                }
            }
            level.playSound(null, pos, blockToPlace.getSoundType(blockToPlace.defaultBlockState(), (LevelReader)level, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        if (!player.isCreative()) {
            player.displayClientMessage((Component)Component.literal((String)("You don't have any " + blockToPlace.getName().getString() + " in your inventory!")), true);
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.isShiftKeyDown()) {
            int nextMode;
            int nextSize;
            int currentSize = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_SIZE)).orElse(3);
            int currentMode = Optional.ofNullable((Integer)stack.get(ModDataComponents.BUILDER_MODE)).orElse(0);
            if (currentMode == 0 && currentSize == 3) {
                nextSize = 10;
                nextMode = 0;
            } else if (currentMode == 0 && currentSize == 10) {
                nextSize = 3;
                nextMode = 1;
            } else if (currentMode == 1 && currentSize == 3) {
                nextSize = 10;
                nextMode = 1;
            } else {
                nextSize = 3;
                nextMode = 0;
            }
            stack.set(ModDataComponents.BUILDER_SIZE, (Object)nextSize);
            stack.set(ModDataComponents.BUILDER_MODE, (Object)nextMode);
            String msg = nextMode == 0 ? (nextSize == 3 ? "Area mode: 7x7" : "Area mode: 21x21") : (nextSize == 3 ? "Line mode: 7 blocks" : "Line mode: 21 blocks");
            player.displayClientMessage((Component)Component.literal((String)msg), true);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private boolean removeBlockFromInventory(Player player, Block block) {
        if (player.isCreative()) {
            return true;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !stack.is(block.asItem())) continue;
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        lastPlaced.remove(new PlayerHandKey(player.getUUID(), InteractionHand.MAIN_HAND));
        lastPlaced.remove(new PlayerHandKey(player.getUUID(), InteractionHand.OFF_HAND));
        return true;
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        UUID id = event.getOriginal().getUUID();
        lastPlaced.entrySet().removeIf(e -> ((PlayerHandKey)e.getKey()).playerId().equals(id));
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        UUID id = event.getEntity().getUUID();
        lastPlaced.entrySet().removeIf(e -> ((PlayerHandKey)e.getKey()).playerId().equals(id));
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID id = event.getEntity().getUUID();
        lastPlaced.entrySet().removeIf(e -> ((PlayerHandKey)e.getKey()).playerId().equals(id));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line2")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line3")));
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line4")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    private record PlayerHandKey(UUID playerId, InteractionHand hand) {
    }

    private static class PlacedEntry {
        private final BlockPos pos;
        private final BlockState previous;
        private final Block placedBlock;

        public PlacedEntry(BlockPos pos, BlockState previous, Block placedBlock) {
            this.pos = pos;
            this.previous = previous;
            this.placedBlock = placedBlock;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getPrevious() {
            return this.previous;
        }

        public Block getPlacedBlock() {
            return this.placedBlock;
        }
    }
}

