/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.client.input;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.client.keymap.ModKeyMappings;
import net.ricmc.betterblockz.network.ModPayloads;

@EventBusSubscriber(modid="betterblockz", value={Dist.CLIENT})
public class MouseInputHandler {
    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        boolean isBlockZVariant;
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null) {
            return;
        }
        ItemStack stack = mc.player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block heldBlock = blockItem.getBlock();
        boolean bl = isBlockZVariant = ModBlocks.VARIANTS.values().stream().flatMap(Arrays::stream).anyMatch(def -> def.get() == heldBlock) || ModBlocks.CYBERLIGHT_THIN.stream().anyMatch(def -> def.get() == heldBlock) || ModBlocks.CYBERLIGHT_THIN_ALT.stream().anyMatch(def -> def.get() == heldBlock) || ModBlocks.CYBERLIGHT_BAR.stream().anyMatch(def -> def.get() == heldBlock) || ModBlocks.CYBERLIGHT_BAR_VERTICAL.stream().anyMatch(def -> def.get() == heldBlock);
        if (isBlockZVariant && ModKeyMappings.getBlockzScrollModifier().isDown()) {
            double scrollDeltaY = event.getScrollDeltaY();
            if (scrollDeltaY > 0.0) {
                ModPayloads.sendBlockZScroll(false);
                event.setCanceled(true);
            } else if (scrollDeltaY < 0.0) {
                ModPayloads.sendBlockZScroll(true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onMouseButton(InputEvent.MouseButton.Pre event) {
        boolean isBlockZVariant;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null) {
            return;
        }
        if (event.getButton() != 2 || event.getAction() != 1) {
            return;
        }
        if (!ModKeyMappings.getBlockzScrollModifier().isDown()) {
            return;
        }
        ItemStack stack = mc.player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block heldBlock = blockItem.getBlock();
        boolean bl = isBlockZVariant = ModBlocks.VARIANTS.values().stream().flatMap(Arrays::stream).anyMatch(def -> def.get() == heldBlock) || ModBlocks.CYBERLIGHT_THIN.stream().anyMatch(def -> def.get() == heldBlock) || ModBlocks.CYBERLIGHT_THIN_ALT.stream().anyMatch(def -> def.get() == heldBlock) || ModBlocks.CYBERLIGHT_BAR.stream().anyMatch(def -> def.get() == heldBlock) || ModBlocks.CYBERLIGHT_BAR_VERTICAL.stream().anyMatch(def -> def.get() == heldBlock);
        if (isBlockZVariant) {
            ModPayloads.sendBlockZResetVariant();
            event.setCanceled(true);
        }
    }
}

