/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block.custom;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class RandomTextureBlock
extends Block {
    public static final IntegerProperty VARIANT = IntegerProperty.create((String)"variant", (int)0, (int)6);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    public RandomTextureBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VARIANT, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VARIANT, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)VARIANT, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            this.scheduleNextCheck(level, pos);
        }
    }

    private void scheduleNextCheck(Level level, BlockPos pos) {
        int delay = 200 + level.getRandom().nextInt(400);
        level.scheduleTick(pos, (Block)this, delay);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)VARIANT) == 0) {
            if (random.nextInt(2000) == 0) {
                int flashVariant = 1 + random.nextInt(6);
                level.setBlock(pos, (BlockState)state.setValue((Property)VARIANT, (Comparable)Integer.valueOf(flashVariant)), 3);
                level.scheduleTick(pos, (Block)this, 1);
            } else {
                this.scheduleNextCheck((Level)level, pos);
            }
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)VARIANT, (Comparable)Integer.valueOf(0)), 3);
            this.scheduleNextCheck((Level)level, pos);
        }
    }
}

