/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class MuralCTMBlock
extends Block {
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    public static final EnumProperty<MuralCorner> CORNER = EnumProperty.create((String)"corner", MuralCorner.class);

    public MuralCTMBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue(CORNER, (Comparable)((Object)MuralCorner.BOTTOM_LEFT)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, CORNER});
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (level.isClientSide) {
            return;
        }
        Direction facing = placer.getDirection();
        level.setBlock(pos, (BlockState)state.setValue(CORNER, (Comparable)((Object)MuralCorner.BOTTOM_LEFT)), 3);
        BlockPos brPos = pos.relative(facing.getClockWise());
        BlockPos tlPos = pos.relative(facing.getOpposite());
        BlockPos trPos = pos.relative(facing.getClockWise()).relative(facing.getOpposite());
        this.placePart(level, brPos, MuralCorner.BOTTOM_RIGHT);
        this.placePart(level, tlPos, MuralCorner.TOP_LEFT);
        this.placePart(level, trPos, MuralCorner.TOP_RIGHT);
    }

    private MuralCorner rotateCorner(MuralCorner corner, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> corner;
            case Direction.EAST -> {
                switch (corner.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield MuralCorner.BOTTOM_RIGHT;
                    }
                    case 3: {
                        yield MuralCorner.TOP_RIGHT;
                    }
                    case 1: {
                        yield MuralCorner.TOP_LEFT;
                    }
                    case 0: 
                }
                yield MuralCorner.BOTTOM_LEFT;
            }
            case Direction.SOUTH -> {
                switch (corner.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield MuralCorner.TOP_RIGHT;
                    }
                    case 3: {
                        yield MuralCorner.TOP_LEFT;
                    }
                    case 1: {
                        yield MuralCorner.BOTTOM_LEFT;
                    }
                    case 0: 
                }
                yield MuralCorner.BOTTOM_RIGHT;
            }
            case Direction.WEST -> {
                switch (corner.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 2: {
                        yield MuralCorner.TOP_LEFT;
                    }
                    case 3: {
                        yield MuralCorner.BOTTOM_LEFT;
                    }
                    case 1: {
                        yield MuralCorner.BOTTOM_RIGHT;
                    }
                    case 0: 
                }
                yield MuralCorner.TOP_RIGHT;
            }
            default -> corner;
        };
    }

    private void placePart(Level level, BlockPos pos, MuralCorner corner) {
        if (!level.getBlockState(pos).canBeReplaced()) {
            return;
        }
        level.setBlock(pos, (BlockState)((BlockState)this.defaultBlockState().setValue(CORNER, (Comparable)((Object)corner))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
    }

    public void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide || !state.hasProperty((Property)LIT)) {
            return;
        }
        boolean lit = (Boolean)state.getValue((Property)LIT);
        if (!lit) {
            return;
        }
        boolean powered = level.hasNeighborSignal(pos);
        if (powered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1.0f;
    }

    public static enum MuralCorner implements StringRepresentable
    {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

