/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.ricmc.betterblockz.block.custom.CTMBlock;
import net.ricmc.betterblockz.block.custom.CobbleTransmuterBlock;
import net.ricmc.betterblockz.block.custom.ConversionBlock;
import net.ricmc.betterblockz.block.custom.CyberLightRedstoneControlBlock;
import net.ricmc.betterblockz.block.custom.FlatBarLightBlock;
import net.ricmc.betterblockz.block.custom.FlatBarLightVerticalBlock;
import net.ricmc.betterblockz.block.custom.GlowingBlock;
import net.ricmc.betterblockz.block.custom.GlowingCTMBlock;
import net.ricmc.betterblockz.block.custom.GlowingPillarBlock;
import net.ricmc.betterblockz.block.custom.LightPanelBlock;
import net.ricmc.betterblockz.block.custom.MultiTextureBlock;
import net.ricmc.betterblockz.block.custom.MuralCTMBlock;
import net.ricmc.betterblockz.block.custom.NumberFlatBlock;
import net.ricmc.betterblockz.block.custom.RotatableBlock;
import net.ricmc.betterblockz.block.custom.TintedGlassBlock;
import net.ricmc.betterblockz.block.custom.TopRotateBlock;
import net.ricmc.betterblockz.block.custom.VariantShufflerBlock;
import net.ricmc.betterblockz.block.custom.WallOrFloorLightBlock;
import net.ricmc.betterblockz.item.ModItems;
import net.ricmc.betterblockz.item.custom.TooltipBlockItem;
import net.ricmc.betterblockz.sound.ModSound;
import net.ricmc.betterblockz.util.CustomColorMap;
import net.ricmc.betterblockz.util.ModColorSets;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"betterblockz");
    public static final DeferredBlock<Block> DIRT_BLOCKZ = ModBlocks.registerBlock("dirt_blockz", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.ROOTED_DIRT).strength(0.3f).speedFactor(1.4f)));
    public static final DeferredBlock<Block> STONE_BLOCKZ = ModBlocks.registerBlock("stone_blockz", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).sound(SoundType.STONE).strength(0.5f).speedFactor(1.4f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> AURORA_BLOCKZ = ModBlocks.registerBlock("aurora_blockz", () -> new ConversionBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).sound(SoundType.GLASS).strength(0.1f).speedFactor(1.4f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> TRANSMUTER_BLOCKZ = ModBlocks.registerBlock("transmuter_blockz", () -> new CobbleTransmuterBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).sound(SoundType.STONE).strength(0.5f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BLOCKZ_CORE = ModBlocks.registerBlock("blockz_core", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).sound(SoundType.STONE).strength(0.5f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> Z_MOVING = ModBlocks.registerBlock("z_moving", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).sound(SoundType.STONE).strength(0.5f).speedFactor(1.4f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> VARIANT_SHUFFLER = ModBlocks.registerBlock("variant_shuffler", () -> new VariantShufflerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).sound(SoundType.STONE).strength(0.2f).requiresCorrectToolForDrops()));
    public static final Map<String, BaseConfig> BASE_CONFIGS = new LinkedHashMap<String, BaseConfig>();
    public static final Map<String, DeferredBlock<?>[]> VARIANTS;
    public static final Map<String, int[]> VARIANTS_PILLARS;
    public static final Map<String, int[]> VARIANTS_CTM;
    public static final List<DeferredBlock<Block>> CYBERLIGHT_THIN;
    public static final List<DeferredBlock<Block>> CYBERLIGHT_THIN_ALT;
    public static final List<DeferredBlock<Block>> CYBERLIGHT_BAR;
    public static final List<DeferredBlock<Block>> CYBERLIGHT_BAR_VERTICAL;
    public static final List<DeferredBlock<Block>> CYBERLIGHT_ALL;
    public static final DeferredBlock<Block> FLAT_LAMP;

    public static Block getBlockByKey(String key) {
        for (DeferredBlock<?>[] blocks : VARIANTS.values()) {
            for (DeferredBlock<?> def : blocks) {
                if (!def.getId().getPath().equals(key)) continue;
                return (Block)def.get();
            }
        }
        return null;
    }

    private static BlockBehaviour.Properties getProps(String name, MapColor mapColor) {
        BlockBehaviour.Properties properties;
        if (name.endsWith("_blockz")) {
            name = name.substring(0, name.length() - "_blockz".length());
        }
        String string = name;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"copper", "forgecopper", "metalzone_copper", "metalzone_rustycopper", "iron", "gold", "diamond", "cyberlight", "cyberlight_alt", "cyberlight_secret", "cyberlight_cycle", String.class, "tintedglass", "tank", "number", "metalzone_iron", "metalzone_rustyiron", "ztyl", "reactor", "reactor_1", "reactor_7"}, (Object)string2, n)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.COPPER).strength(1.5f, 6.0f).requiresCorrectToolForDrops();
                    break block11;
                }
                case 4: 
                case 5: 
                case 6: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.METAL).strength(1.4f, 6.0f).requiresCorrectToolForDrops();
                    break block11;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.GLASS).strength(0.3f, 6.0f).lightLevel(state -> state.hasProperty((Property)CyberLightRedstoneControlBlock.LIT) && (Boolean)state.getValue((Property)CyberLightRedstoneControlBlock.LIT) != false ? 15 : 0);
                    break block11;
                }
                case 11: {
                    String s = string2;
                    if (!s.startsWith("zeon")) {
                        n = 12;
                        continue block11;
                    }
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.STONE).strength(1.5f, 6.0f).lightLevel(b -> 15).requiresCorrectToolForDrops();
                    break block11;
                }
                case 12: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.GLASS).strength(0.5f, 6.0f).noOcclusion();
                    break block11;
                }
                case 13: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.METAL).strength(1.5f, 1200.0f).requiresCorrectToolForDrops();
                    break block11;
                }
                case 14: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.STONE).strength(0.3f, 6.0f).noOcclusion();
                    break block11;
                }
                case 15: 
                case 16: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound((SoundType)ModSound.METALZONE_IRON_SOUND).strength(1.5f, 6.0f).requiresCorrectToolForDrops();
                    break block11;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.NETHERITE_BLOCK).strength(1.5f, 6.0f).requiresCorrectToolForDrops();
                    break block11;
                }
                default: {
                    properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(SoundType.METAL).strength(1.5f, 6.0f).requiresCorrectToolForDrops();
                    break block11;
                }
            }
            break;
        }
        return properties;
    }

    private static DeferredBlock<?>[] registerVariants(String baseName, int variantCount, int[] pillarIndices, int[] ctmIndices, int[] rotatableIndices, int[] topRotateIndices, int[] muralctmIndices, int[] glowingIndices, int[] multiIndices) {
        DeferredBlock[] arr = new DeferredBlock[variantCount];
        for (int i = 0; i < variantCount; ++i) {
            int idx = i;
            String name = baseName + "_" + idx;
            MapColor color = CustomColorMap.getVariantColor(baseName, idx);
            BlockBehaviour.Properties props = ModBlocks.getProps(baseName, color);
            Supplier<Block> supplier = ModBlocks.contains(pillarIndices, idx) ? (baseName.startsWith("zeon") ? () -> new GlowingPillarBlock(props) : () -> new RotatedPillarBlock(props)) : (ModBlocks.contains(ctmIndices, idx) ? (baseName.startsWith("zeon") ? () -> new GlowingCTMBlock(props) : () -> new CTMBlock(props)) : (ModBlocks.contains(rotatableIndices, idx) ? () -> new RotatableBlock(props) : (ModBlocks.contains(topRotateIndices, idx) ? () -> new TopRotateBlock(props) : (ModBlocks.contains(muralctmIndices, idx) ? () -> new MuralCTMBlock(props) : (ModBlocks.contains(glowingIndices, idx) ? () -> new GlowingBlock(props) : (baseName.startsWith("cyberlight") ? () -> new CyberLightRedstoneControlBlock(props) : (baseName.startsWith("zeon") ? () -> new GlowingBlock(props) : (baseName.startsWith("tintedglass") ? () -> new TintedGlassBlock(props) : (baseName.startsWith("number") ? () -> new NumberFlatBlock(props) : (ModBlocks.contains(multiIndices, idx) ? () -> new MultiTextureBlock(props) : () -> new Block(props)))))))))));
            DeferredBlock block = BLOCKS.register(name, supplier);
            ModItems.ITEMS.register(name, () -> new TooltipBlockItem((Block)block.get(), new Item.Properties()));
            arr[i] = block;
        }
        return arr;
    }

    private static boolean contains(int[] arr, int value) {
        for (int v : arr) {
            if (v != value) continue;
            return true;
        }
        return false;
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    private static void registerColorFamily(String prefix, BaseConfig configTemplate) {
        for (ModColorSets.SetColor color : ModColorSets.SetColor.values()) {
            BASE_CONFIGS.put(color.withPrefix(prefix), configTemplate);
        }
    }

    private static List<DeferredBlock<Block>> registerCyberlights(String baseName, int count, Supplier<Block> blockSupplier) {
        ArrayList<DeferredBlock<Block>> list = new ArrayList<DeferredBlock<Block>>();
        for (int i = 0; i < count; ++i) {
            String name = baseName + i;
            DeferredBlock<Block> block = ModBlocks.registerBlock(name, blockSupplier);
            list.add(block);
        }
        return list;
    }

    static {
        BASE_CONFIGS.put("forgecopper", new BaseConfig(16, new int[]{5, 6, 7}, new int[0], new int[]{9}, new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("ironslate", new BaseConfig(22, new int[]{5, 6, 7, 13, 16, 17, 18, 19}, new int[]{20, 21}, new int[]{9, 11}, new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("crimson", new BaseConfig(8, new int[]{2, 6}, new int[]{3}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("ironslateredstone", new BaseConfig(3, new int[]{2}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("hazard", new BaseConfig(10, new int[0], new int[0], IntStream.range(0, 10).toArray(), new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("eclipse", new BaseConfig(8, new int[]{2, 4}, new int[]{6}, new int[]{7}, new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("armz", new BaseConfig(16, new int[]{3, 4, 5, 6, 10}, new int[]{8, 14}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("synthalloy", new BaseConfig(14, new int[]{2, 3, 5, 6}, new int[]{7, 8, 9, 10, 11, 12, 13}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("ambercore", new BaseConfig(14, new int[]{2, 5, 6}, new int[]{4, 7, 8, 9, 10, 11, 12, 13}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("lablink", new BaseConfig(8, new int[]{7}, new int[]{2, 3}, new int[0], new int[]{4, 5}, new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("cyberlight", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("iron", new BaseConfig(11, new int[]{4, 8}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("copper", new BaseConfig(10, new int[]{4, 8}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("gold", new BaseConfig(10, new int[]{4, 8}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("diamond", new BaseConfig(10, new int[]{4, 8}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("cyberlight_alt", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("cyberlight_secret", new BaseConfig(18, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("agon", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("lave", new BaseConfig(18, new int[]{3, 5, 11, 17}, new int[0], new int[]{9}, new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("mint", new BaseConfig(16, new int[]{11}, new int[]{4, 6}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("myst", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("vect", new BaseConfig(16, new int[]{3, 11}, new int[0], new int[]{15}, new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("vena", new BaseConfig(16, new int[]{4}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("azur", new BaseConfig(16, new int[]{6, 7}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("jelt", new BaseConfig(16, new int[]{6, 14}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("korp", new BaseConfig(18, new int[]{2, 5, 12, 15}, new int[]{3, 6, 9, 11, 13, 14, 17}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("bitt", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("reed", new BaseConfig(16, new int[]{5, 8, 9, 10}, new int[]{2, 7}, new int[]{11, 14}, new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("cray", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("ztyl", new BaseConfig(11, new int[]{3, 4}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("iszm", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("fort", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("zane", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("zoea", new BaseConfig(4, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        for (int i = 0; i <= 3; ++i) {
            BASE_CONFIGS.put("zoea_" + i, new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        }
        BASE_CONFIGS.put("lairblood", new BaseConfig(6, new int[]{2, 4, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("lairflesh", new BaseConfig(6, new int[]{2, 4, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("lairhusk", new BaseConfig(6, new int[]{2, 4, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("lairdecay", new BaseConfig(6, new int[]{2, 4, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("lairstain", new BaseConfig(6, new int[]{2, 4, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("tintedglass", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("stone", new BaseConfig(2, new int[0], new int[]{0, 1}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("tank", new BaseConfig(16, new int[]{3, 4, 5, 6, 10, 12, 13, 14}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("number", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        ModBlocks.registerColorFamily("zeon", new BaseConfig(8, new int[]{2, 3, 4, 6}, new int[]{0}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        ModBlocks.registerColorFamily("zeno", new BaseConfig(16, new int[]{2, 3, 4, 5, 7, 8, 10, 13, 14, 15}, new int[]{6}, new int[]{9}, new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("zenohex", new BaseConfig(16, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("metalzone_iron", new BaseConfig(8, new int[]{2, 3, 4}, new int[]{0}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("metalzone_rustyiron", new BaseConfig(8, new int[]{2, 3, 4}, new int[]{0}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("metalzone_copper", new BaseConfig(8, new int[]{2, 3, 4}, new int[]{0}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("metalzone_rustycopper", new BaseConfig(8, new int[]{2, 3, 4}, new int[]{0}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("gold_frame_platform", new BaseConfig(4, new int[]{2}, new int[]{0, 1, 3}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("diamond_frame_platform", new BaseConfig(4, new int[]{2}, new int[]{0, 1, 3}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("reactor", new BaseConfig(8, new int[]{3, 4}, new int[]{1, 2, 5, 6, 7}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("reactor_1", new BaseConfig(16, new int[0], IntStream.range(0, 16).toArray(), new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("reactor_7", new BaseConfig(16, new int[0], IntStream.range(0, 16).toArray(), new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("kryp", new BaseConfig(24, new int[]{19, 20, 22}, new int[]{8, 9, 12, 13, 14, 23}, new int[0], new int[0], new int[0], new int[0], new int[0]));
        BASE_CONFIGS.put("cyberlight_cycle", new BaseConfig(1, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0]));
        VARIANTS = new LinkedHashMap<String, DeferredBlock<?>[]>();
        VARIANTS_PILLARS = new LinkedHashMap<String, int[]>();
        VARIANTS_CTM = new LinkedHashMap<String, int[]>();
        for (Map.Entry<String, BaseConfig> entry : BASE_CONFIGS.entrySet()) {
            String name = entry.getKey();
            BaseConfig cfg = entry.getValue();
            VARIANTS.put(name, ModBlocks.registerVariants(name + "_blockz", cfg.variantCount(), cfg.pillars(), cfg.ctm(), cfg.rotatables(), cfg.topRotates(), cfg.mural(), cfg.glowing(), cfg.multi()));
            VARIANTS_PILLARS.put(name, cfg.pillars());
            VARIANTS_CTM.put(name, cfg.ctm());
        }
        CYBERLIGHT_THIN = ModBlocks.registerCyberlights("cyberlight_thin_", 16, () -> new WallOrFloorLightBlock(BlockBehaviour.Properties.of().strength(0.3f).sound(SoundType.GLASS).noOcclusion().lightLevel(b -> 15)));
        CYBERLIGHT_THIN_ALT = ModBlocks.registerCyberlights("cyberlight_thin_alt_", 16, () -> new LightPanelBlock(BlockBehaviour.Properties.of().strength(0.3f).sound(SoundType.GLASS).noOcclusion().lightLevel(b -> 15)));
        CYBERLIGHT_BAR = ModBlocks.registerCyberlights("cyberlight_bar_", 16, () -> new FlatBarLightBlock(BlockBehaviour.Properties.of().strength(0.3f).sound(SoundType.GLASS).noOcclusion().lightLevel(b -> 15)));
        CYBERLIGHT_BAR_VERTICAL = ModBlocks.registerCyberlights("cyberlight_bar_vertical_", 16, () -> new FlatBarLightVerticalBlock(BlockBehaviour.Properties.of().strength(0.3f).sound(SoundType.GLASS).noOcclusion().lightLevel(b -> 15)));
        CYBERLIGHT_ALL = new ArrayList<DeferredBlock<Block>>(){
            {
                this.addAll(CYBERLIGHT_THIN);
                this.addAll(CYBERLIGHT_THIN_ALT);
                this.addAll(CYBERLIGHT_BAR);
                this.addAll(CYBERLIGHT_BAR_VERTICAL);
            }
        };
        FLAT_LAMP = ModBlocks.registerBlock("flat_lamp", () -> new WallOrFloorLightBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(0.3f).sound(SoundType.GLASS).noOcclusion().lightLevel(b -> 15)));
    }

    public record BaseConfig(int variantCount, int[] pillars, int[] ctm, int[] rotatables, int[] topRotates, int[] mural, int[] glowing, int[] multi) {
    }
}

