/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.registry;

import baguchan.earthmobsmod.data.CustomTagGenerator;
import baguchan.earthmobsmod.item.BoneShardItem;
import baguchan.earthmobsmod.item.FixedInstrumentItem;
import baguchan.earthmobsmod.item.MobPotItem;
import baguchan.earthmobsmod.item.ModEggItem;
import baguchan.earthmobsmod.item.TropicalBallItem;
import baguchan.earthmobsmod.registry.ModBlocks;
import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModFluids;
import baguchan.earthmobsmod.registry.ModFoods;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="earthmobsmod")
public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"earthmobsmod");
    public static final Supplier<Item> RUBY = ITEMS.register("ruby", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> TROPICAL_BALL = ITEMS.register("tropical_ball", () -> new TropicalBallItem(new Item.Properties()));
    public static final Supplier<Item> SMELLY_EGG = ITEMS.register("smelly_egg", () -> new ModEggItem(ModEntities.SMELLY_EGG, new Item.Properties().stacksTo(16)));
    public static final Supplier<Item> FANCY_EGG = ITEMS.register("fancy_egg", () -> new ModEggItem(ModEntities.FANCY_EGG, new Item.Properties().stacksTo(16)));
    public static final Supplier<Item> DUCK_EGG = ITEMS.register("duck_egg", () -> new ModEggItem(ModEntities.DUCK_EGG, new Item.Properties().stacksTo(16)));
    public static final Supplier<Item> BONE_SHARD = ITEMS.register("bone_shard", () -> new BoneShardItem(new Item.Properties()));
    public static final Supplier<Item> FANCY_FEATHER = ITEMS.register("fancy_feather", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> HARDER_FLESH = ITEMS.register("harder_flesh", () -> new Item(new Item.Properties().food(ModFoods.HARDER_FLESH)));
    public static final Supplier<Item> BONE_SPIDER_EYE = ITEMS.register("bone_spider_eye", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> HORN = ITEMS.register("horn", () -> new Item(new Item.Properties().stacksTo(1)));
    public static final Supplier<Item> HORN_FLUTE = ITEMS.register("horn_flute", () -> new FixedInstrumentItem(new Item.Properties().stacksTo(1), CustomTagGenerator.InstrumentTagGenerator.HORNED_SHEEP));
    public static final Supplier<Item> HYPER_RABBIT_FOOT = ITEMS.register("hyper_rabbit_foot", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> ZOMBIFIED_RABBIT_FOOT = ITEMS.register("zombified_rabbit_foot", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> MUD_BUCKET = ITEMS.register("mud_bucket", () -> new BucketItem((Fluid)ModFluids.MUD.value(), new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
    public static final Supplier<Item> TROPICAL_SLIME_BUCKET = ITEMS.register("tropical_slime_bucket", () -> new MobBucketItem(ModEntities.TROPICAL_SLIME.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
    public static final Supplier<Item> TEACUP_PIG_POT = ITEMS.register("teacup_pig_pot", () -> new MobPotItem(ModEntities.TEACUP_PIG.get(), Fluids.EMPTY, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), new Item.Properties().stacksTo(1).craftRemainder(Items.FLOWER_POT)));
    public static final Supplier<Item> CLUCK_SHROOM_SPAWNEGG = ITEMS.register("cluck_shroom_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.CLUCK_SHROOM, 11873303, 14452795, new Item.Properties()));
    public static final Supplier<Item> FANCY_CHICKEN_SPAWNEGG = ITEMS.register("fancy_chicken_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.FANCY_CHICKEN, 16032275, 0x202F22, new Item.Properties()));
    public static final Supplier<Item> WOOLY_COW_SPAWNEGG = ITEMS.register("wooly_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.WOOLY_COW, 14387528, 16767926, new Item.Properties()));
    public static final Supplier<Item> UMBRA_COW_SPAWNEGG = ITEMS.register("umbra_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.UMBRA_COW, 4210263, 658205, new Item.Properties()));
    public static final Supplier<Item> ALBINO_COW_SPAWNEGG = ITEMS.register("albino_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.ALBINO_COW, 0xECE2E2, 14798799, new Item.Properties()));
    public static final Supplier<Item> ASHEN_COW_SPAWNEGG = ITEMS.register("ashen_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.ASHEN_COW, 6117990, 9012369, new Item.Properties()));
    public static final Supplier<Item> CREAM_COW_SPAWNEGG = ITEMS.register("cream_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.CREAM_COW, 14855003, 15260859, new Item.Properties()));
    public static final Supplier<Item> COOKIE_COW_SPAWNEGG = ITEMS.register("cookie_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.COOKIE_COW, 5002850, 15458517, new Item.Properties()));
    public static final Supplier<Item> DAIRY_COW_SPAWNEGG = ITEMS.register("dairy_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.DAIRY_COW, 16184569, 0x2E2E2D, new Item.Properties()));
    public static final Supplier<Item> PINTO_COW_SPAWNEGG = ITEMS.register("pinto_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.PINTO_COW, 15390919, 11886110, new Item.Properties()));
    public static final Supplier<Item> SUNSET_COW_SPAWNEGG = ITEMS.register("sunset_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.SUNSET_COW, 15043897, 1512724, new Item.Properties()));
    public static final Supplier<Item> TEACUP_PIG_SPAWNEGG = ITEMS.register("teacup_pig_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.TEACUP_PIG, 15649217, 0xDD5555, new Item.Properties()));
    public static final Supplier<Item> HORNED_SHEEP_SPAWNEGG = ITEMS.register("horned_sheep_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.HORNED_SHEEP, 0xE7E7E7, 0xFFB5B5, new Item.Properties()));
    public static final Supplier<Item> HYPER_RABBIT_SPAWNEGG = ITEMS.register("hyper_rabbit_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.HYPER_RABBIT, 14317642, 16039811, new Item.Properties()));
    public static final Supplier<Item> MOOBLOOM_SPAWNEGG = ITEMS.register("moobloom_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.MOOBLOOM, 16632320, 16248257, new Item.Properties()));
    public static final Supplier<Item> MOOLIP_SPAWNEGG = ITEMS.register("moolip_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.MOOLIP, 14189232, 15851496, new Item.Properties()));
    public static final Supplier<Item> JUMBO_RABBIT_SPAWNEGG = ITEMS.register("jumbo_rabbit_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.JUMBO_RABBIT, 10378312, 15053475, new Item.Properties()));
    public static final Supplier<Item> ZOMBIFILED_PIG_SPAWNEGG = ITEMS.register("zombified_pig_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.ZOMBIFIED_PIG, 15373203, 5009705, new Item.Properties()));
    public static final Supplier<Item> DUCK_SPAWNEGG = ITEMS.register("duck_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.DUCK, 6570298, 1545502, new Item.Properties()));
    public static final Supplier<Item> JOLLY_LAMMA_SPAWNEGG = ITEMS.register("jolly_llama_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.JOLLY_LLAMA, 6764327, 13811634, new Item.Properties()));
    public static final Supplier<Item> BONE_SPIDER_SPAWNEGG = ITEMS.register("bone_spider_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.BONE_SPIDER, 4594734, 6369463, new Item.Properties()));
    public static final Supplier<Item> VILER_WITCH_SPAWNEGG = ITEMS.register("viler_witch_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.VILER_WITCH, 0x111322, 3622477, new Item.Properties()));
    public static final Supplier<Item> BOULDERING_ZOMBIE_SPAWNEGG = ITEMS.register("bouldering_zombie_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.BOULDERING_ZOMBIE, 3686978, 5383706, new Item.Properties()));
    public static final Supplier<Item> LOBBER_ZOMBIE_SPAWNEGG = ITEMS.register("lobber_zombie_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.LOBBER_ZOMBIE, 9015924, 4417624, new Item.Properties()));
    public static final Supplier<Item> BOULDERING_DROWNED_SPAWNEGG = ITEMS.register("bouldering_drowned_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.BOULDERING_DROWNED, 5670014, 5383706, new Item.Properties()));
    public static final Supplier<Item> LOBBER_DROWNED_SPAWNEGG = ITEMS.register("lobber_drowned_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.LOBBER_DROWNED, 7574132, 4087633, new Item.Properties()));
    public static final Supplier<Item> BOULDERING_FROZEN_ZOMBIE_SPAWNEGG = ITEMS.register("bouldering_frozen_zombie_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.BOULDERING_FROZEN_ZOMBIE, 6789776, 1395028, new Item.Properties()));
    public static final Supplier<Item> LOBBER_HUSK_SPAWNEGG = ITEMS.register("lobber_husk_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.LOBBER_HUSK, 7103572, 0xCFCFCF, new Item.Properties()));
    public static final Supplier<Item> TROPICAL_SLIME_SPAWNEGG = ITEMS.register("tropical_slime_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.TROPICAL_SLIME, 5997485, 9482707, new Item.Properties()));
    public static final Supplier<Item> SKELETON_WOLF_SPAWNEGG = ITEMS.register("skeleton_wolf_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.SKELETON_WOLF, 0xC1C1C1, 0x494949, new Item.Properties()));
    public static final Supplier<Item> WITHER_SKELETON_WOLF_SPAWNEGG = ITEMS.register("wither_skeleton_wolf_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.WITHER_SKELETON_WOLF, 0x141414, 0x474D4D, new Item.Properties()));
    public static final Supplier<Item> BABY_GHAST_SPAWNEGG = ITEMS.register("baby_ghast_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.BABY_GHAST, 0xFFFFFF, 0xFF9393, new Item.Properties()));
    public static final Supplier<Item> ZOMBIFIED_RABBIT_SPAWNEGG = ITEMS.register("zombified_rabbit_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.ZOMBIFIED_RABBIT, 7974249, 2773297, new Item.Properties()));
    public static final Supplier<Item> MAGMA_COW_SPAWNEGG = ITEMS.register("magma_cow_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.MAGMA_COW, 0x2C2C33, 16493145, new Item.Properties()));
    public static final Supplier<Item> MELON_GOLEM_SPAWNEGG = ITEMS.register("melon_golem_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.MELON_GOLEM, 14283506, 3438878, new Item.Properties()));
    public static final Supplier<Item> FURNACE_GOLEM_SPAWNEGG = ITEMS.register("furnace_golem_spawn_egg", () -> new DeferredSpawnEggItem(ModEntities.FURNACE_GOLEM, 14405058, 9394246, new Item.Properties()));

    private static void generateInstrumentTypes(CreativeModeTab.Output p_270699_, HolderLookup<Instrument> p_270948_, Item p_270421_, TagKey<Instrument> p_270798_, CreativeModeTab.TabVisibility p_270817_) {
        p_270948_.get(p_270798_).ifPresent(p_270021_ -> p_270021_.stream().map(p_269995_ -> InstrumentItem.create((Item)p_270421_, (Holder)p_269995_)).forEach(p_270011_ -> p_270699_.accept(p_270011_, p_270817_)));
    }

    @SubscribeEvent
    public static void registerCreativeTabsItem(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)CLUCK_SHROOM_SPAWNEGG.get());
            event.accept((ItemLike)FANCY_CHICKEN_SPAWNEGG.get());
            event.accept((ItemLike)WOOLY_COW_SPAWNEGG.get());
            event.accept((ItemLike)UMBRA_COW_SPAWNEGG.get());
            event.accept((ItemLike)ALBINO_COW_SPAWNEGG.get());
            event.accept((ItemLike)ASHEN_COW_SPAWNEGG.get());
            event.accept((ItemLike)CREAM_COW_SPAWNEGG.get());
            event.accept((ItemLike)COOKIE_COW_SPAWNEGG.get());
            event.accept((ItemLike)DAIRY_COW_SPAWNEGG.get());
            event.accept((ItemLike)PINTO_COW_SPAWNEGG.get());
            event.accept((ItemLike)SUNSET_COW_SPAWNEGG.get());
            event.accept((ItemLike)TEACUP_PIG_SPAWNEGG.get());
            event.accept((ItemLike)HORNED_SHEEP_SPAWNEGG.get());
            event.accept((ItemLike)HYPER_RABBIT_SPAWNEGG.get());
            event.accept((ItemLike)MOOBLOOM_SPAWNEGG.get());
            event.accept((ItemLike)MOOLIP_SPAWNEGG.get());
            event.accept((ItemLike)JUMBO_RABBIT_SPAWNEGG.get());
            event.accept((ItemLike)ZOMBIFILED_PIG_SPAWNEGG.get());
            event.accept((ItemLike)DUCK_SPAWNEGG.get());
            event.accept((ItemLike)JOLLY_LAMMA_SPAWNEGG.get());
            event.accept((ItemLike)BONE_SPIDER_SPAWNEGG.get());
            event.accept((ItemLike)BABY_GHAST_SPAWNEGG.get());
            event.accept((ItemLike)ZOMBIFIED_RABBIT_SPAWNEGG.get());
            event.accept((ItemLike)BOULDERING_ZOMBIE_SPAWNEGG.get());
            event.accept((ItemLike)BOULDERING_DROWNED_SPAWNEGG.get());
            event.accept((ItemLike)BOULDERING_FROZEN_ZOMBIE_SPAWNEGG.get());
            event.accept((ItemLike)LOBBER_ZOMBIE_SPAWNEGG.get());
            event.accept((ItemLike)LOBBER_DROWNED_SPAWNEGG.get());
            event.accept((ItemLike)LOBBER_HUSK_SPAWNEGG.get());
            event.accept((ItemLike)TROPICAL_SLIME_SPAWNEGG.get());
            event.accept((ItemLike)SKELETON_WOLF_SPAWNEGG.get());
            event.accept((ItemLike)VILER_WITCH_SPAWNEGG.get());
            event.accept((ItemLike)WITHER_SKELETON_WOLF_SPAWNEGG.get());
            event.accept((ItemLike)MAGMA_COW_SPAWNEGG.get());
            event.accept((ItemLike)MELON_GOLEM_SPAWNEGG.get());
            event.accept((ItemLike)FURNACE_GOLEM_SPAWNEGG.get());
        }
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept((ItemLike)RUBY.get());
            event.accept((ItemLike)TROPICAL_BALL.get());
            event.accept((ItemLike)SMELLY_EGG.get());
            event.accept((ItemLike)FANCY_EGG.get());
            event.accept((ItemLike)DUCK_EGG.get());
            event.accept((ItemLike)BONE_SHARD.get());
            event.accept((ItemLike)FANCY_FEATHER.get());
            event.accept((ItemLike)HARDER_FLESH.get());
            event.accept((ItemLike)BONE_SPIDER_EYE.get());
            event.accept((ItemLike)HORN.get());
            event.getParameters().holders().lookup(Registries.INSTRUMENT).ifPresent(p_270036_ -> ModItems.generateInstrumentTypes((CreativeModeTab.Output)event, (HolderLookup<Instrument>)p_270036_, HORN_FLUTE.get(), CustomTagGenerator.InstrumentTagGenerator.HORNED_SHEEP, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            event.accept((ItemLike)HYPER_RABBIT_FOOT.get());
            event.accept((ItemLike)ZOMBIFIED_RABBIT_FOOT.get());
        }
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept((ItemLike)ModBlocks.TROPICAL_SLIME_BLOCK.get());
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)MUD_BUCKET.get());
            event.accept((ItemLike)TROPICAL_SLIME_BUCKET.get());
            event.accept((ItemLike)TEACUP_PIG_POT.get());
        }
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.accept((ItemLike)ModBlocks.CARVED_MELON.get());
            event.accept((ItemLike)ModBlocks.CARVED_MELON_SHOOT.get());
            event.accept((ItemLike)ModBlocks.BUTTERCUP.get());
            event.accept((ItemLike)ModBlocks.PINK_DAISY.get());
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            event.accept((ItemLike)ModBlocks.RUBY.get());
        }
    }

    public static void composterInit() {
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModBlocks.BUTTERCUP.get()), 0.1f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModBlocks.PINK_DAISY.get()), 0.1f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModBlocks.CARVED_MELON.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModBlocks.CARVED_MELON_SHOOT.get()), 0.65f);
    }
}

