/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.registry;

import baguchan.earthmobsmod.block.CarvedMelonBlock;
import baguchan.earthmobsmod.block.TropicalSlimeBlock;
import baguchan.earthmobsmod.registry.ModFluids;
import baguchan.earthmobsmod.registry.ModItems;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"earthmobsmod");
    public static final Supplier<LiquidBlock> MUD = ModBlocks.noItemRegister("mud", () -> new LiquidBlock((FlowingFluid)ModFluids.MUD.value(), BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY)));
    public static final Supplier<Block> RUBY = ModBlocks.register("ruby_block", () -> new Block(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)));
    public static final Supplier<Block> CARVED_MELON = ModBlocks.register("carved_melon", () -> new CarvedMelonBlock(BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.WOOD)));
    public static final Supplier<Block> CARVED_MELON_SHOOT = ModBlocks.register("carved_melon_shoot", () -> new CarvedMelonBlock(BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.WOOD)));
    public static final Supplier<Block> TROPICAL_SLIME_BLOCK = ModBlocks.register("tropical_slime_block", () -> new TropicalSlimeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).friction(0.8f).noOcclusion().sound(SoundType.SLIME_BLOCK)));
    public static final Supplier<FlowerBlock> BUTTERCUP = ModBlocks.register("buttercup", () -> new FlowerBlock(MobEffects.ABSORPTION, 30.0f, BlockBehaviour.Properties.of().noCollission().pushReaction(PushReaction.DESTROY).offsetType(BlockBehaviour.OffsetType.XZ).instabreak().sound(SoundType.GRASS)));
    public static final Supplier<FlowerBlock> PINK_DAISY = ModBlocks.register("pink_daisy", () -> new FlowerBlock(MobEffects.REGENERATION, 10.0f, BlockBehaviour.Properties.of().noCollission().pushReaction(PushReaction.DESTROY).offsetType(BlockBehaviour.OffsetType.XZ).instabreak().sound(SoundType.GRASS)));
    public static final Supplier<Block> POTTED_BUTTERCUP = BLOCKS.register("potted_buttercup", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, BUTTERCUP, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final Supplier<Block> POTTED_PINK_DAISY = BLOCKS.register("potted_pink_daisy", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, PINK_DAISY, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY)));

    private static <T extends Block> Supplier<T> baseRegister(String name, Supplier<? extends T> block, Function<Supplier<T>, Supplier<? extends Item>> item) {
        DeferredHolder register = BLOCKS.register(name, block);
        ModItems.ITEMS.register(name, item.apply((Supplier<DeferredHolder>)register));
        return register;
    }

    private static <T extends Block> Supplier<T> noItemRegister(String name, Supplier<? extends T> block) {
        DeferredHolder register = BLOCKS.register(name, block);
        return register;
    }

    private static <B extends Block> Supplier<B> register(String name, Supplier<? extends Block> block) {
        return ModBlocks.baseRegister(name, block, object -> ModBlocks.registerBlockItem(object));
    }

    private static <T extends Block> Supplier<BlockItem> registerBlockItem(Supplier<T> block) {
        return () -> new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties());
    }

    public static void initFire() {
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        fireblock.setFlammable((Block)BUTTERCUP.get(), 60, 100);
        fireblock.setFlammable((Block)PINK_DAISY.get(), 60, 100);
    }
}

