/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.fluidtype;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Matrix4f;

public class MudFluidType
extends FluidType {
    public MudFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean flag = entity.getDeltaMovement().y <= 0.0;
        double d8 = entity.getY();
        entity.moveRelative(0.02f, movementVector);
        entity.move(MoverType.SELF, entity.getDeltaMovement());
        if (entity.getFluidTypeHeight((FluidType)this) <= entity.getFluidJumpThreshold()) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.75, (double)0.8f, 0.75));
            Vec3 vec33 = entity.getFluidFallingAdjustedMovement(gravity, flag, entity.getDeltaMovement());
            entity.setDeltaMovement(vec33);
        } else {
            entity.setDeltaMovement(entity.getDeltaMovement().scale(0.75));
        }
        if (!entity.isNoGravity()) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -gravity / 4.0, 0.0));
        }
        Vec3 vec34 = entity.getDeltaMovement();
        if (entity.horizontalCollision && entity.isFree(vec34.x, vec34.y + (double)0.6f - entity.getY() + d8, vec34.z)) {
            entity.setDeltaMovement(vec34.x, (double)0.3f, vec34.z);
        }
        return true;
    }

    public static class MudRender
    implements IClientFluidTypeExtensions {
        private static final ResourceLocation TEXTURE_STILL = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"block/mud");
        private static final ResourceLocation TEXTURE_FLOW = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"block/flowing_mud");
        private static final ResourceLocation TEXTURE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/block/mud.png");

        public ResourceLocation getStillTexture() {
            return TEXTURE_STILL;
        }

        public ResourceLocation getFlowingTexture() {
            return TEXTURE_FLOW;
        }

        public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
            return TEXTURE_OVERLAY;
        }

        public void renderOverlay(Minecraft mc, PoseStack stack) {
            ResourceLocation texture = this.getRenderOverlayTexture(mc);
            if (texture == null) {
                return;
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            BlockPos playerEyePos = BlockPos.containing((double)mc.player.getX(), (double)mc.player.getEyeY(), (double)mc.player.getZ());
            float brightness = LightTexture.getBrightness((DimensionType)mc.player.level().dimensionType(), (int)mc.player.level().getMaxLocalRawBrightness(playerEyePos));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.65f);
            float uOffset = -mc.player.getYRot() / 64.0f;
            float vOffset = mc.player.getXRot() / 64.0f;
            Matrix4f pose = stack.last().pose();
            buffer.addVertex(pose, -1.0f, -1.0f, -0.5f).setUv(4.0f + uOffset, 4.0f + vOffset);
            buffer.addVertex(pose, 1.0f, -1.0f, -0.5f).setUv(uOffset, 4.0f + vOffset);
            buffer.addVertex(pose, 1.0f, 1.0f, -0.5f).setUv(uOffset, vOffset);
            buffer.addVertex(pose, -1.0f, 1.0f, -0.5f).setUv(4.0f + uOffset, vOffset);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.disableBlend();
        }
    }
}

