/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity.projectile;

import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModItems;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoneShard
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.defineId(BoneShard.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BoneShard(EntityType<? extends BoneShard> p_37391_, Level p_37392_) {
        super(p_37391_, p_37392_);
    }

    public BoneShard(Level p_37399_, LivingEntity p_37400_) {
        super(ModEntities.BONE_SHARD.get(), p_37400_, p_37399_);
    }

    public BoneShard(Level p_37394_, double p_37395_, double p_37396_, double p_37397_) {
        super(ModEntities.BONE_SHARD.get(), p_37395_, p_37396_, p_37397_, p_37394_);
    }

    public BoneShard(EntityType<? extends BoneShard> entity, double x, double y, double z, Level level) {
        super(entity, x, y, z, level);
    }

    public BoneShard(EntityType<? extends BoneShard> entity, Level level, LivingEntity livingEntity) {
        super(entity, livingEntity, level);
    }

    protected Item getDefaultItem() {
        return ModItems.BONE_SHARD.get();
    }

    private ParticleOptions getParticle() {
        return new ItemParticleOption(ParticleTypes.ITEM, ModItems.BONE_SHARD.get().getDefaultInstance());
    }

    private void updateColor() {
        PotionContents potioncontents = this.getPotionContents();
        this.entityData.set(ID_EFFECT_COLOR, (Object)(potioncontents.equals((Object)PotionContents.EMPTY) ? -1 : potioncontents.getColor()));
    }

    public void addEffect(MobEffectInstance p_36871_) {
        this.setPotionContents(this.getPotionContents().withEffectAdded(p_36871_));
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326324_) {
        super.defineSynchedData(p_326324_);
        p_326324_.define(ID_EFFECT_COLOR, (Object)-1);
    }

    public void handleEntityEvent(byte p_36869_) {
        if (p_36869_ == 0) {
            int i = this.getColor();
            if (i != -1) {
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i >> 0 & 0xFF) / 255.0f;
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)f, (float)f1, (float)f2), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.handleEntityEvent(p_36869_);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.makeParticle(2);
        }
    }

    private void makeParticle(int p_36877_) {
        int i = this.getColor();
        if (i != -1 && p_36877_ > 0) {
            for (int j = 0; j < p_36877_; ++j) {
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)i), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(ID_EFFECT_COLOR);
    }

    public PotionContents getPotionContents() {
        return (PotionContents)this.getItem().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    public void setPotionContents(PotionContents p_331534_) {
        this.getItem().set(DataComponents.POTION_CONTENTS, (Object)p_331534_);
        this.updateColor();
    }

    protected void onHitEntity(EntityHitResult p_37404_) {
        Entity entity = p_37404_.getEntity();
        Vec3 projectileMovement = this.getDeltaMovement();
        int damage = Mth.ceil((double)(3.0 * projectileMovement.length()));
        if (damage > 0 && entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage) && entity instanceof LivingEntity) {
            for (MobEffectInstance mobeffectinstance : this.getPotionContents().getAllEffects()) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(mobeffectinstance.getEffect(), Math.max(mobeffectinstance.getDuration() / 8, 1), mobeffectinstance.getAmplifier(), mobeffectinstance.isAmbient(), mobeffectinstance.isVisible()), entity);
            }
        }
    }

    protected void onHit(HitResult p_37488_) {
        super.onHit(p_37488_);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(SoundEvents.TURTLE_EGG_BREAK, 0.4f, 1.25f);
            this.discard();
        }
    }
}

