/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity.goal;

import baguchan.earthmobsmod.entity.BabyGhast;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class SitEvenFlying
extends Goal {
    private final BabyGhast mob;

    public SitEvenFlying(BabyGhast p_25898_) {
        this.mob = p_25898_;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return this.mob.isInSittingPose();
    }

    public boolean canUse() {
        if (this.mob.isInWaterOrBubble()) {
            return false;
        }
        if (!this.mob.onGround()) {
            return false;
        }
        LivingEntity livingentity = this.mob.getOwner();
        if (livingentity == null) {
            return false;
        }
        return this.mob.distanceToSqr((Entity)livingentity) < 144.0 && livingentity.getLastHurtByMob() != null ? false : this.mob.isInSittingPose();
    }

    public void start() {
        this.mob.getNavigation().stop();
        this.mob.setInSittingPose(true);
    }

    public void stop() {
        this.mob.setInSittingPose(false);
    }
}

