/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModItems;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;

public class TropicalSlime
extends Slime
implements Bucketable {
    public static final EntityDataAccessor<CompoundTag> DATA_FISHS = SynchedEntityData.defineId(TropicalSlime.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(TropicalSlime.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final String TAG_FISH_VARIANT = "FishVariant";
    public static final String TAG_FISH_POSX = "FishPosX";
    public static final String TAG_FISH_POSY = "FishPosY";
    public static final String TAG_FISH_POSZ = "FishPosZ";
    public static final String TAG_FISH_LIST = "FishList";

    public TropicalSlime(EntityType<? extends Slime> p_33588_, Level p_33589_) {
        super(p_33588_, p_33589_);
        this.moveControl = new SlimeMoveControl(this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FISHS, (Object)new CompoundTag());
        builder.define(FROM_BUCKET, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new SlimeAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.goalSelector.addGoal(5, (Goal)new SlimeKeepOnJumpingGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p_33641_ -> Math.abs(p_33641_.getY() - this.getY()) <= 4.0));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Nullable
    public CompoundTag getFishData() {
        return (CompoundTag)this.entityData.get(DATA_FISHS);
    }

    @Nullable
    public ListTag getFishList() {
        if (this.getFishData() != null) {
            return (ListTag)this.getFishData().get(TAG_FISH_LIST);
        }
        return null;
    }

    public void setFishData(CompoundTag p_36363_) {
        this.entityData.set(DATA_FISHS, (Object)p_36363_);
    }

    public CompoundTag writeFromBucketTag(ItemStack p_149163_) {
        CompoundTag newTag = new CompoundTag();
        if (p_149163_.get(DataComponents.BUCKET_ENTITY_DATA) != null) {
            newTag = ((CustomData)p_149163_.get(DataComponents.BUCKET_ENTITY_DATA)).copyTag();
        }
        return newTag;
    }

    public InteractionResult mobInteract(Player p_28941_, InteractionHand p_28942_) {
        ItemStack itemstack = p_28941_.getItemInHand(p_28942_);
        if (itemstack.is(Items.TROPICAL_FISH_BUCKET)) {
            CompoundTag tag = this.writeFromBucketTag(itemstack);
            if (this.getFishList() == null || !this.getFishList().isEmpty() && this.getFishList().size() < 4) {
                if (!tag.isEmpty()) {
                    this.addFishData(tag.getInt(TAG_FISH_VARIANT), false);
                } else {
                    int i = this.random.nextInt(2);
                    int j = this.random.nextInt(6);
                    int k = this.random.nextInt(15);
                    int l = this.random.nextInt(15);
                    this.addFishData(i | j << 8 | k << 16 | l << 24, false);
                }
            } else {
                return InteractionResult.FAIL;
            }
            ItemStack itemstack1 = new ItemStack((ItemLike)Items.BUCKET);
            ItemStack itemstack2 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)p_28941_, (ItemStack)itemstack1, (boolean)false);
            p_28941_.setItemInHand(p_28942_, itemstack2);
            SoundEvent soundevent = SoundEvents.BUCKET_EMPTY_FISH;
            this.playSound(soundevent, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return this.isTiny() ? Bucketable.bucketMobPickup((Player)p_28941_, (InteractionHand)p_28942_, (LivingEntity)this).orElse(super.mobInteract(p_28941_, p_28942_)) : super.mobInteract(p_28941_, p_28942_);
    }

    protected void randomFishData(boolean small) {
        int i = this.random.nextInt(2);
        int j = this.random.nextInt(6);
        int k = this.random.nextInt(15);
        int l = this.random.nextInt(15);
        this.addFishData(i | j << 8 | k << 16 | l << 24, small);
    }

    protected void addFishData(int variant, boolean small) {
        CompoundTag fishTag = this.getFishData().isEmpty() ? new CompoundTag() : this.getFishData();
        ListTag listnbt = new ListTag();
        if (fishTag.contains(TAG_FISH_LIST)) {
            listnbt = fishTag.getList(TAG_FISH_LIST, 10);
        }
        CompoundTag compoundnbt1 = new CompoundTag();
        compoundnbt1.putInt(TAG_FISH_VARIANT, variant);
        EntityDimensions dimensions = this.getDimensions(this.getPose());
        double x = ((double)dimensions.width() * this.random.nextDouble() - (double)dimensions.width() * this.random.nextDouble()) * 0.5;
        double y = (double)dimensions.height() * this.random.nextDouble() * (double)0.8f + (double)(dimensions.height() * 0.1f);
        double z = ((double)dimensions.width() * this.random.nextDouble() - (double)dimensions.width() * this.random.nextDouble()) * 0.5;
        if (small) {
            x = ((double)0.6f * this.random.nextDouble() - (double)0.6f * this.random.nextDouble()) * 0.5;
            y = (double)0.6f * this.random.nextDouble() * (double)0.8f + 0.06000000238418579;
            z = ((double)0.6f * this.random.nextDouble() - (double)0.6f * this.random.nextDouble()) * 0.5;
        }
        compoundnbt1.putDouble(TAG_FISH_POSX, x);
        compoundnbt1.putDouble(TAG_FISH_POSY, y);
        compoundnbt1.putDouble(TAG_FISH_POSZ, z);
        listnbt.add((Object)compoundnbt1);
        fishTag.put(TAG_FISH_LIST, (Tag)listnbt);
        this.setFishData(fishTag);
    }

    public void remove(Entity.RemovalReason p_149847_) {
        super.remove(p_149847_);
        CompoundTag compoundTag = this.getFishData();
        if (this.isDeadOrDying() && compoundTag != null && compoundTag.get(TAG_FISH_LIST) != null) {
            int i = this.getSize();
            ListTag listTag = (ListTag)compoundTag.get(TAG_FISH_LIST);
            float f = (float)i / 4.0f;
            for (int l = 0; l < listTag.size(); ++l) {
                double f1 = ((CompoundTag)listTag.get(l)).getDouble(TAG_FISH_POSX);
                double f2 = ((CompoundTag)listTag.get(l)).getDouble(TAG_FISH_POSZ);
                double f3 = ((CompoundTag)listTag.get(l)).getDouble(TAG_FISH_POSY);
                TropicalFish fish = (TropicalFish)EntityType.TROPICAL_FISH.create(this.level());
                if (this.isPersistenceRequired()) {
                    fish.setPersistenceRequired();
                }
                fish.setPackedVariant(((CompoundTag)listTag.get(l)).getInt(TAG_FISH_VARIANT));
                fish.setInvulnerable(this.isInvulnerable());
                fish.moveTo(this.getX() + f1, this.getY() + f3, this.getZ() + f2, this.random.nextFloat() * 360.0f, 0.0f);
                this.level().addFreshEntity((Entity)fish);
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag p_33619_) {
        super.addAdditionalSaveData(p_33619_);
        if (this.getFishData() != null) {
            p_33619_.put("FishData", (Tag)this.getFishData());
        }
    }

    public void readAdditionalSaveData(CompoundTag p_33607_) {
        super.readAdditionalSaveData(p_33607_);
        if (p_33607_.contains("FishData")) {
            this.setFishData(p_33607_.getCompound("FishData"));
        }
    }

    protected ParticleOptions getParticleType() {
        return new ItemParticleOption(ParticleTypes.ITEM, ModItems.TROPICAL_BALL.get().getDefaultInstance());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_30023_, DifficultyInstance p_30024_, MobSpawnType p_30025_, @Nullable SpawnGroupData p_30026_) {
        p_30026_ = super.finalizeSpawn(p_30023_, p_30024_, p_30025_, p_30026_);
        int size = Mth.clamp((int)this.getSize(), (int)1, (int)5);
        for (int i = 0; i < size; ++i) {
            this.randomFishData(p_30025_ == MobSpawnType.BUCKET);
        }
        return p_30026_;
    }

    public static boolean checkTropicalSpawnRules(EntityType<TropicalSlime> p_32350_, ServerLevelAccessor p_32351_, MobSpawnType p_32352_, BlockPos p_32353_, RandomSource p_32354_) {
        if (!p_32351_.getFluidState(p_32353_.below()).is(FluidTags.WATER)) {
            return false;
        }
        Holder holder = p_32351_.getBiome(p_32353_);
        boolean flag = p_32351_.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.isSpawner((MobSpawnType)p_32352_) || p_32351_.getFluidState(p_32353_).is(FluidTags.WATER) && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)p_32351_, (BlockPos)p_32353_, (RandomSource)p_32354_));
        return p_32354_.nextInt(30) == 0 && flag;
    }

    public boolean checkSpawnObstruction(LevelReader p_32370_) {
        return p_32370_.isUnobstructed((Entity)this);
    }

    float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * f;
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_149196_) {
        this.entityData.set(FROM_BUCKET, (Object)p_149196_);
    }

    public void saveToBucketTag(ItemStack p_149187_) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)p_149187_);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)p_149187_, compoundTag -> {
            if (this.getFishData() != null) {
                compoundTag.put("FishData", (Tag)this.getFishData());
            }
        });
    }

    public void loadFromBucketTag(CompoundTag p_149163_) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)p_149163_);
        this.setSize(1, true);
        if (p_149163_.contains("FishData")) {
            this.setFishData(p_149163_.getCompound("FishData"));
        }
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.TROPICAL_SLIME_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    public void travel(Vec3 p_32394_) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), p_32394_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(p_32394_);
        }
    }

    static class SlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final TropicalSlime slime;
        private boolean isAggressive;

        public SlimeMoveControl(TropicalSlime p_33668_) {
            super((Mob)p_33668_);
            this.slime = p_33668_;
            this.yRot = 180.0f * p_33668_.getYRot() / (float)Math.PI;
        }

        public void setDirection(float p_33673_, boolean p_33674_) {
            this.yRot = p_33673_;
            this.isAggressive = p_33674_;
        }

        public void setWantedY(double y) {
            this.wantedY = y;
        }

        public void setWantedMovement(double p_33671_) {
            this.speedModifier = p_33671_;
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        public void tick() {
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, -0.008, 0.0));
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), this.yRot, 90.0f));
            this.mob.yHeadRot = this.mob.getYRot();
            this.mob.yBodyRot = this.mob.getYRot();
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                this.mob.setSpeed(0.0f);
                this.mob.setZza(0.0f);
            } else {
                this.operation = MoveControl.Operation.WAIT;
                if (this.mob.isInWater() && !this.mob.onGround()) {
                    float f1 = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    double d1 = this.wantedY - this.mob.getY();
                    boolean flag = d1 < 0.0 && this.mob.getTarget() != null;
                    float f2 = Mth.lerp((float)0.125f, (float)this.mob.getSpeed(), (float)f1);
                    this.mob.setSpeed(f2);
                    if (flag && Math.abs(d1) > (double)1.0E-5f) {
                        this.mob.setYya(f2 * 3.0f);
                    }
                } else if (this.mob.onGround()) {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.getJumpControl().jump();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.playSound(this.slime.getJumpSound(), this.slime.getSoundVolume(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.xxa = 0.0f;
                        this.mob.setZza(0.0f);
                        this.mob.setSpeed(0.0f);
                    }
                } else {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                }
            }
        }
    }

    static class SlimeAttackGoal
    extends Goal {
        private final TropicalSlime slime;
        private int growTiredTimer;

        public SlimeAttackGoal(TropicalSlime p_33648_) {
            this.slime = p_33648_;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.slime.getTarget();
            if (livingentity == null) {
                return false;
            }
            return !this.slime.canAttack(livingentity) ? false : this.slime.getMoveControl() instanceof SlimeMoveControl;
        }

        public void start() {
            this.growTiredTimer = SlimeAttackGoal.reducedTickDelay((int)300);
            super.start();
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = this.slime.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!this.slime.canAttack(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.slime.getTarget();
            if (livingentity != null) {
                this.slime.lookAt((Entity)livingentity, 10.0f, 10.0f);
                ((SlimeMoveControl)this.slime.getMoveControl()).setWantedY(livingentity.getY());
            }
            ((SlimeMoveControl)this.slime.getMoveControl()).setDirection(this.slime.getYRot(), this.slime.isDealsDamage());
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final TropicalSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(TropicalSlime p_33679_) {
            this.slime = p_33679_;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.slime.getTarget() == null && (this.slime.onGround() || this.slime.isInWater() || this.slime.isInLava() || this.slime.hasEffect(MobEffects.LEVITATION)) && this.slime.getMoveControl() instanceof SlimeMoveControl;
        }

        public void tick() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.adjustedTickDelay(40 + this.slime.getRandom().nextInt(60));
                this.chosenDegrees = this.slime.getRandom().nextInt(360);
            }
            ((SlimeMoveControl)this.slime.getMoveControl()).setDirection(this.chosenDegrees, false);
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final Slime slime;

        public SlimeKeepOnJumpingGoal(Slime p_33660_) {
            this.slime = p_33660_;
        }

        public boolean canUse() {
            return !this.slime.isPassenger();
        }

        public void tick() {
            ((SlimeMoveControl)this.slime.getMoveControl()).setWantedMovement(1.0);
        }
    }
}

