/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.api.IMuddyPig;
import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModItems;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.Nullable;

public class TeaCupPig
extends Pig
implements IShearable,
Bucketable {
    public TeaCupPig(EntityType<? extends Pig> p_29462_, Level p_29463_) {
        super(p_29462_, p_29463_);
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.35f;
    }

    @Nullable
    public TeaCupPig getBreedOffspring(ServerLevel p_149001_, AgeableMob p_149002_) {
        return (TeaCupPig)ModEntities.TEACUP_PIG.get().create((Level)p_149001_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.24);
    }

    public InteractionResult mobInteract(Player p_149155_, InteractionHand p_149156_) {
        return TeaCupPig.bucketMobPickup(p_149155_, p_149156_, this).orElse(super.mobInteract(p_149155_, p_149156_));
    }

    static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player p_148829_, InteractionHand p_148830_, T p_148831_) {
        ItemStack itemstack = p_148829_.getItemInHand(p_148830_);
        if (itemstack.getItem() == Items.FLOWER_POT && p_148831_.isAlive()) {
            p_148831_.playSound(((Bucketable)p_148831_).getPickupSound(), 1.0f, 1.0f);
            ItemStack itemstack1 = ((Bucketable)p_148831_).getBucketItemStack();
            ((Bucketable)p_148831_).saveToBucketTag(itemstack1);
            ItemStack itemstack2 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)p_148829_, (ItemStack)itemstack1, (boolean)false);
            p_148829_.setItemInHand(p_148830_, itemstack2);
            Level level = p_148831_.level();
            if (!level.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)p_148829_, itemstack1);
            }
            p_148831_.discard();
            return Optional.of(InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
        return Optional.empty();
    }

    public boolean fromBucket() {
        return false;
    }

    public void setFromBucket(boolean p_148834_) {
    }

    public void saveToBucketTag(ItemStack p_149187_) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)p_149187_);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)p_149187_, compoundtag -> {
            compoundtag.putInt("Age", this.getAge());
            TeaCupPig patt0$temp = this;
            if (patt0$temp instanceof IMuddyPig) {
                IMuddyPig muddy = (IMuddyPig)((Object)patt0$temp);
                compoundtag.putBoolean("Muddy", muddy.isMuddy());
            }
        });
    }

    public void loadFromBucketTag(CompoundTag p_149163_) {
        TeaCupPig teaCupPig;
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)p_149163_);
        if (p_149163_.contains("Age")) {
            this.setAge(p_149163_.getInt("Age"));
        }
        if ((teaCupPig = this) instanceof IMuddyPig) {
            IMuddyPig muddy = (IMuddyPig)((Object)teaCupPig);
            if (p_149163_.contains("Muddy")) {
                muddy.setMuddy(p_149163_.getBoolean("Muddy"));
            }
        }
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ModItems.TEACUP_PIG_POT.get());
    }

    public SoundEvent getPickupSound() {
        return (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value();
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return false;
    }
}

