/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.projectile.MelonSeed;
import baguchan.earthmobsmod.registry.ModBlocks;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class MelonGolem
extends AbstractGolem
implements Shearable,
RangedAttackMob,
IShearable {
    private static final EntityDataAccessor<Byte> DATA_MELON_ID = SynchedEntityData.defineId(MelonGolem.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final byte MELON_FLAG = 16;
    private static final float EYE_HEIGHT = 1.7f;

    public MelonGolem(EntityType<? extends MelonGolem> p_29902_, Level p_29903_) {
        super(p_29902_, p_29903_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ShootSeedGoal(this));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, p_29932_ -> p_29932_ instanceof Enemy));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_MELON_ID, (Object)16);
    }

    public void addAdditionalSaveData(CompoundTag p_29923_) {
        super.addAdditionalSaveData(p_29923_);
        p_29923_.putBoolean("Melon", this.hasMelon());
    }

    public void readAdditionalSaveData(CompoundTag p_29915_) {
        super.readAdditionalSaveData(p_29915_);
        if (p_29915_.contains("Melon")) {
            this.setMelon(p_29915_.getBoolean("Melon"));
        }
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public boolean canAttackType(EntityType<?> p_28851_) {
        return p_28851_ == EntityType.CREEPER ? false : super.canAttackType(p_28851_);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)this.getY());
            int k = Mth.floor((double)this.getZ());
            BlockPos blockPos = new BlockPos(i, 0, k);
            if (((Biome)this.level().getBiome(blockPos).value()).getBaseTemperature() > 1.0f) {
                this.hurt(this.damageSources().onFire(), 1.0f);
            }
            if (!EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
                return;
            }
            BlockState blockstate = Blocks.SNOW.defaultBlockState();
            for (int l = 0; l < 4; ++l) {
                i = Mth.floor((double)(this.getX() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                j = Mth.floor((double)this.getY());
                k = Mth.floor((double)(this.getZ() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j, k);
                if (!this.level().isEmptyBlock(blockpos) || !(((Biome)this.level().getBiome(blockpos).value()).getBaseTemperature() < 0.8f) || !blockstate.canSurvive((LevelReader)this.level(), blockpos)) continue;
                this.level().setBlockAndUpdate(blockpos, blockstate);
            }
        }
    }

    public void performRangedAttack(LivingEntity target, float p_29913_) {
        MelonSeed melonSeed = new MelonSeed(this.level(), (LivingEntity)this);
        double d0 = target.getEyeY() - (double)1.1f;
        double d1 = target.getX() - this.getX();
        double d2 = d0 - melonSeed.getY();
        double d3 = target.getZ() - this.getZ();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        melonSeed.shoot(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)melonSeed);
    }

    protected float getStandingEyeHeight(Pose p_29917_, EntityDimensions p_29918_) {
        return 1.7f;
    }

    protected InteractionResult mobInteract(Player p_29920_, InteractionHand p_29921_) {
        ItemStack itemstack = p_29920_.getItemInHand(p_29921_);
        return InteractionResult.PASS;
    }

    public void shear(SoundSource p_29907_) {
        this.level().playSound((Player)null, (Entity)this, SoundEvents.SNOW_GOLEM_SHEAR, p_29907_, 1.0f, 1.0f);
        if (!this.level().isClientSide()) {
            this.setMelon(false);
            this.spawnAtLocation(new ItemStack((ItemLike)ModBlocks.CARVED_MELON.get()), 1.7f);
        }
    }

    public boolean readyForShearing() {
        return this.isAlive() && this.hasMelon();
    }

    public boolean hasMelon() {
        return ((Byte)this.entityData.get(DATA_MELON_ID) & 0x10) != 0;
    }

    public void setMelon(boolean p_29937_) {
        byte b0 = (Byte)this.entityData.get(DATA_MELON_ID);
        if (p_29937_) {
            this.entityData.set(DATA_MELON_ID, (Object)((byte)(b0 | 0x10)));
        } else {
            this.entityData.set(DATA_MELON_ID, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    @javax.annotation.Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.SNOW_GOLEM_AMBIENT;
    }

    @javax.annotation.Nullable
    protected SoundEvent getHurtSound(DamageSource p_29929_) {
        return SoundEvents.SNOW_GOLEM_HURT;
    }

    @javax.annotation.Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.SNOW_GOLEM_DEATH;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.75f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return this.readyForShearing();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        level.playSound(null, (Entity)this, SoundEvents.SNOW_GOLEM_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.isClientSide()) {
            this.setMelon(false);
            return Collections.singletonList(new ItemStack((ItemLike)ModBlocks.CARVED_MELON.get()));
        }
        return Collections.emptyList();
    }

    static class ShootSeedGoal
    extends Goal {
        private final MelonGolem golem;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public ShootSeedGoal(MelonGolem melonGolem) {
            this.golem = melonGolem;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.golem.getTarget();
            return livingentity != null && livingentity.isAlive() && this.golem.canAttack(livingentity) && this.lastSeen < 200;
        }

        public void start() {
            this.attackStep = 0;
            this.golem.setAggressive(true);
        }

        public void stop() {
            this.lastSeen = 0;
            this.golem.setAggressive(false);
        }

        public void tick() {
            --this.attackTime;
            LivingEntity livingentity = this.golem.getTarget();
            if (livingentity != null) {
                boolean flag = this.golem.getSensing().hasLineOfSight((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.golem.distanceToSqr((Entity)livingentity);
                if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 10;
                        } else if (this.attackStep <= 5) {
                            this.attackTime = 5;
                        } else {
                            this.attackTime = 10;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            this.golem.performRangedAttack(livingentity, this.attackTime);
                        }
                    }
                    this.golem.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                }
                if (d0 >= 100.0 && d0 < this.getFollowDistance() * this.getFollowDistance() && flag || this.lastSeen >= 5) {
                    this.golem.getNavigation().moveTo(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                } else {
                    this.golem.getNavigation().stop();
                }
                super.tick();
            }
        }

        private double getFollowDistance() {
            return this.golem.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }
}

