/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.goal.GoToWaterGoal;
import baguchan.earthmobsmod.entity.goal.RangedAndMeleeAttack;
import baguchan.earthmobsmod.entity.projectile.ZombieFlesh;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;

public class LobberDrowned
extends Drowned
implements RangedAttackMob {
    public AnimationState shootAnimationState = new AnimationState();

    public LobberDrowned(EntityType<? extends LobberDrowned> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(1, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new RangedAndMeleeAttack(this, 1.0, 40, 6.5f, 11){

            @Override
            public void doAttackAnimation() {
                LobberDrowned.this.level().broadcastEntityEvent((Entity)this.mob, (byte)61);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> ((LobberDrowned)this).canBreakDoors()));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{ZombifiedPiglin.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true, false));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
    }

    public void handleEntityEvent(byte id) {
        if (id == 61) {
            this.shootAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 2.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    public void performRangedAttack(LivingEntity p_29912_, float p_29913_) {
        if (this.getMainHandItem().is(Items.TRIDENT)) {
            ThrownTrident throwntrident = new ThrownTrident(this.level(), (LivingEntity)this, new ItemStack((ItemLike)Items.TRIDENT));
            double d0 = p_29912_.getX() - this.getX();
            double d1 = p_29912_.getY(0.3333333333333333) - throwntrident.getY();
            double d2 = p_29912_.getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            throwntrident.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
            this.playSound(SoundEvents.DROWNED_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)throwntrident);
        } else {
            ZombieFlesh zombieFlesh = new ZombieFlesh(this.level(), (LivingEntity)this);
            double d0 = p_29912_.getEyeY() - this.getEyeY();
            double d1 = p_29912_.getX() - this.getX();
            double d3 = p_29912_.getZ() - this.getZ();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.1f;
            zombieFlesh.shoot(d1, d0 + d4, d3, 0.9f, this.isUnderWater() ? 0.85f : 0.1f);
            zombieFlesh.setDrowned(true);
            zombieFlesh.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200));
            this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)zombieFlesh);
        }
    }

    public static boolean checkLobberDrownedSpawnRules(EntityType<LobberDrowned> p_32350_, ServerLevelAccessor p_32351_, MobSpawnType p_32352_, BlockPos p_32353_, RandomSource p_32354_) {
        boolean flag;
        if (!p_32351_.getFluidState(p_32353_.below()).is(FluidTags.WATER)) {
            return false;
        }
        Holder holder = p_32351_.getBiome(p_32353_);
        boolean bl = flag = p_32351_.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.isSpawner((MobSpawnType)p_32352_) || p_32351_.getFluidState(p_32353_).is(FluidTags.WATER) && LobberDrowned.isDarkEnoughToSpawn((ServerLevelAccessor)p_32351_, (BlockPos)p_32353_, (RandomSource)p_32354_));
        if (!holder.is(Biomes.RIVER) && !holder.is(Biomes.FROZEN_RIVER)) {
            return p_32354_.nextInt(40) == 0 && LobberDrowned.isDeepEnoughToSpawn((LevelAccessor)p_32351_, p_32353_) && flag;
        }
        return p_32354_.nextInt(15) == 0 && flag;
    }

    private static boolean isDeepEnoughToSpawn(LevelAccessor p_32367_, BlockPos p_32368_) {
        return p_32368_.getY() < p_32367_.getSeaLevel() - 5;
    }
}

