/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import bagu_chan.bagus_lib.client.camera.CameraCore;
import bagu_chan.bagus_lib.client.camera.holder.CameraHolder;
import bagu_chan.bagus_lib.util.GlobalVec3;
import baguchan.earthmobsmod.data.CustomTagGenerator;
import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModItems;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HornedSheep
extends Sheep {
    private static final EntityDataAccessor<Boolean> DATA_HAS_HORN = SynchedEntityData.defineId(HornedSheep.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private float aggressiveScale;
    private float aggressiveScaleOld;

    public HornedSheep(EntityType<? extends Sheep> p_29806_, Level p_29807_) {
        super(p_29806_, p_29807_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_HAS_HORN, (Object)true);
    }

    protected void registerGoals() {
        this.eatBlockGoal = new EatBlockGoal((Mob)this);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3f){

            public boolean canUse() {
                return !HornedSheep.this.hasHorn() && super.canUse();
            }

            public boolean canContinueToUse() {
                return !HornedSheep.this.hasHorn() && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal<Goat>((PathfinderMob)this, Goat.class, 12.0f, 1.3, 1.35){

            public boolean canUse() {
                return !HornedSheep.this.hasHorn() && super.canUse();
            }

            public boolean canContinueToUse() {
                return !HornedSheep.this.hasHorn() && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new HornedSheepAttackGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), false));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(7, (Goal)this.eatBlockGoal);
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                return super.canUse() && HornedSheep.this.hasHorn();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && HornedSheep.this.hasHorn();
            }
        }.setAlertOthers(new Class[0]));
    }

    public boolean hasHorn() {
        return (Boolean)this.entityData.get(DATA_HAS_HORN);
    }

    public boolean dropHorn() {
        boolean flag = this.hasHorn();
        if (!flag) {
            return false;
        }
        this.entityData.set(DATA_HAS_HORN, (Object)false);
        Vec3 vec3 = this.position();
        ItemStack itemstack = this.createHorn();
        double d0 = Mth.randomBetween((RandomSource)this.random, (float)-0.2f, (float)0.2f);
        double d1 = Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)0.7f);
        double d2 = Mth.randomBetween((RandomSource)this.random, (float)-0.2f, (float)0.2f);
        ItemEntity itementity = new ItemEntity(this.level(), vec3.x(), vec3.y(), vec3.z(), itemstack, d0, d1, d2);
        this.level().addFreshEntity((Entity)itementity);
        ItemEntity itementity2 = new ItemEntity(this.level(), vec3.x(), vec3.y(), vec3.z(), itemstack, d0, d1, d2);
        this.level().addFreshEntity((Entity)itementity2);
        return true;
    }

    public ItemStack createHorn() {
        RandomSource randomsource = RandomSource.create((long)this.getUUID().hashCode());
        TagKey<Instrument> tagkey = CustomTagGenerator.InstrumentTagGenerator.HORNED_SHEEP;
        HolderSet.Named holderset = BuiltInRegistries.INSTRUMENT.getOrCreateTag(tagkey);
        return InstrumentItem.create((Item)ModItems.HORN_FLUTE.get(), (Holder)((Holder)holderset.getRandomElement(randomsource).get()));
    }

    public void addHorns() {
        this.entityData.set(DATA_HAS_HORN, (Object)true);
    }

    public void addAdditionalSaveData(CompoundTag p_149385_) {
        super.addAdditionalSaveData(p_149385_);
        p_149385_.putBoolean("HasHorn", this.hasHorn());
    }

    public void readAdditionalSaveData(CompoundTag p_149373_) {
        super.readAdditionalSaveData(p_149373_);
        this.entityData.set(DATA_HAS_HORN, (Object)p_149373_.getBoolean("HasHorn"));
    }

    public void aiStep() {
        this.updateSwingTime();
        super.aiStep();
        if (this.level().isClientSide) {
            this.aggressiveScaleOld = this.aggressiveScale;
            this.aggressiveScale = this.isAggressive() ? Mth.clamp((float)(this.aggressiveScale + 0.2f), (float)0.0f, (float)1.0f) : Mth.clamp((float)(this.aggressiveScale - 0.2f), (float)0.0f, (float)1.0f);
        }
    }

    public float getAggressiveAnimationScale(float p_29570_) {
        return Mth.lerp((float)p_29570_, (float)this.aggressiveScaleOld, (float)this.aggressiveScale);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Sheep.createAttributes().add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_KNOCKBACK, (double)0.9f);
    }

    public HornedSheep getBreedOffspring(ServerLevel p_149035_, AgeableMob p_149036_) {
        return (HornedSheep)ModEntities.HORNED_SHEEP.get().create((Level)p_149035_);
    }

    public boolean hurt(DamageSource damagesource, float p_27568_) {
        Entity entity1 = damagesource.getEntity();
        if (entity1 != null && entity1 instanceof LivingEntity) {
            this.setLastHurtByMob((LivingEntity)entity1);
        }
        return super.hurt(damagesource, p_27568_);
    }

    public static class HornedSheepAttackGoal
    extends Goal {
        private final HornedSheep hornedSheep;
        private boolean rushing = true;
        private BlockPos targetPos;
        private int rushTick;
        private int rushCooldowmTick;
        public int ticksUntilNextAttack;
        private boolean attack;

        public HornedSheepAttackGoal(HornedSheep hornedSheep) {
            this.hornedSheep = hornedSheep;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.hornedSheep.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            return this.hornedSheep.hasHorn();
        }

        public boolean canContinueToUse() {
            return this.hornedSheep.getTarget() != null && this.hornedSheep.getTarget().isAlive() && this.hornedSheep.hasHorn();
        }

        public void start() {
            super.start();
            this.targetPos = null;
            this.rushTick = 200;
            this.hornedSheep.setAggressive(true);
            this.rushing = true;
        }

        public void stop() {
            super.stop();
            this.attack = false;
            this.hornedSheep.setAggressive(false);
        }

        public void tick() {
            LivingEntity livingentity = this.hornedSheep.getTarget();
            if (livingentity != null) {
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                if (this.rushing) {
                    if (this.rushTick == 140) {
                        this.targetPos = livingentity.blockPosition();
                    }
                    if (this.rushTick <= 140) {
                        if (this.targetPos != null) {
                            this.hornedSheep.getLookControl().setLookAt((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), 30.0f, 30.0f);
                            this.hornedSheep.getMoveControl().setWantedPosition((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), 2.5);
                        }
                        if (this.hasRammedHornBreakingBlock(this.hornedSheep.level(), this.hornedSheep)) {
                            boolean flag = this.hornedSheep.dropHorn();
                            if (flag) {
                                this.hornedSheep.level().playSound((Player)null, (Entity)this.hornedSheep, SoundEvents.GOAT_HORN_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            }
                            CameraCore.addCameraHolderList((Level)this.hornedSheep.level(), (CameraHolder)new CameraHolder(12, 30, 0.1f, GlobalVec3.of((ResourceKey)this.hornedSheep.level().dimension(), (Vec3)this.hornedSheep.position())));
                            this.rushCooldowmTick = 200 + this.hornedSheep.random.nextInt(200);
                            this.rushing = false;
                        }
                        if (this.hornedSheep.position().closerThan((Position)this.targetPos.getCenter(), 0.25)) {
                            this.rushCooldowmTick = 200 + this.hornedSheep.random.nextInt(200);
                            this.rushing = false;
                        }
                    }
                    if (this.rushTick > 0) {
                        --this.rushTick;
                    }
                    if (this.rushing && this.rushTick <= 0 || this.attack && this.rushTick > 0) {
                        this.rushCooldowmTick = 200 + this.hornedSheep.random.nextInt(200);
                        this.rushing = false;
                    }
                } else {
                    if (this.rushCooldowmTick > 0) {
                        --this.rushCooldowmTick;
                    }
                    if (this.rushCooldowmTick <= 0) {
                        this.rushing = true;
                        this.rushTick = 200;
                        this.attack = false;
                    }
                    this.hornedSheep.getNavigation().moveTo((Entity)livingentity, (double)1.1f);
                }
                if (this.rushing && this.rushTick <= 140 || !this.rushing && this.ticksUntilNextAttack <= 0) {
                    this.checkAndPerformAttack(livingentity);
                }
            }
        }

        protected void checkAndPerformAttack(LivingEntity p_25557_) {
            double d0 = this.getAttackReachSqr(p_25557_);
            if (!(!this.hornedSheep.isWithinMeleeAttackRange(p_25557_) || this.attack && this.rushing)) {
                this.hornedSheep.swing(InteractionHand.MAIN_HAND);
                if (!this.rushing) {
                    this.hornedSheep.doHurtTarget((Entity)p_25557_);
                    this.attack = true;
                } else {
                    int i = this.hornedSheep.hasEffect(MobEffects.MOVEMENT_SPEED) ? this.hornedSheep.getEffect(MobEffects.MOVEMENT_SPEED).getAmplifier() + 1 : 0;
                    int j = this.hornedSheep.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) ? this.hornedSheep.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() + 1 : 0;
                    float f = 0.25f * (float)(i - j);
                    float f1 = Mth.clamp((float)(this.hornedSheep.getSpeed() * 1.65f), (float)0.2f, (float)3.0f) + f;
                    float f2 = p_25557_.isDamageSourceBlocked(this.hornedSheep.damageSources().mobAttack((LivingEntity)this.hornedSheep)) ? 0.5f : 1.0f;
                    p_25557_.knockback((double)(f2 * f1) * (double)(this.hornedSheep.isBaby() ? 0.2f : 1.5f), this.hornedSheep.getX() - p_25557_.getX(), this.hornedSheep.getZ() - p_25557_.getZ());
                    p_25557_.hurt(this.hornedSheep.damageSources().mobAttack((LivingEntity)this.hornedSheep), (float)this.hornedSheep.getAttributeValue(Attributes.ATTACK_DAMAGE) + 2.0f);
                }
                this.ticksUntilNextAttack = 30;
            }
        }

        protected double getAttackReachSqr(LivingEntity p_25556_) {
            return this.hornedSheep.getBbWidth() * 2.0f * this.hornedSheep.getBbWidth() * 2.0f + p_25556_.getBbWidth();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        private boolean hasRammedHornBreakingBlock(Level p_217363_, HornedSheep p_217364_) {
            Vec3 vec3 = p_217364_.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
            BlockPos blockpos = BlockPos.containing((Position)p_217364_.position().add(vec3));
            return p_217363_.getBlockState(blockpos).is(BlockTags.SNAPS_GOAT_HORN) || p_217363_.getBlockState(blockpos.above()).is(BlockTags.SNAPS_GOAT_HORN);
        }
    }
}

