/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class BoulderingZombie
extends Zombie {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(BoulderingZombie.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public BoulderingZombie(EntityType<? extends BoulderingZombie> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, (double)0.22f).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    protected void doUnderWaterConversion() {
        this.convertToZombieType(ModEntities.BOULDERING_DROWNED.get());
        if (!this.isSilent()) {
            this.level().levelEvent((Player)null, 1040, this.blockPosition(), 0);
        }
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    public static boolean checkBoulderingSpawnRules(EntityType<? extends BoulderingZombie> p_32350_, ServerLevelAccessor p_32351_, MobSpawnType p_32352_, BlockPos p_32353_, RandomSource p_32354_) {
        Holder holder = p_32351_.getBiome(p_32353_);
        boolean flag = p_32351_.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.isSpawner((MobSpawnType)p_32352_) || p_32353_.getY() < 0 && BoulderingZombie.isDarkEnoughToSpawn((ServerLevelAccessor)p_32351_, (BlockPos)p_32353_, (RandomSource)p_32354_) || p_32351_.getBiome(p_32353_).is(BiomeTags.IS_MOUNTAIN) && BoulderingZombie.isDarkEnoughToSpawn((ServerLevelAccessor)p_32351_, (BlockPos)p_32353_, (RandomSource)p_32354_));
        return BoulderingZombie.checkMobSpawnRules(p_32350_, (LevelAccessor)p_32351_, (MobSpawnType)p_32352_, (BlockPos)p_32353_, (RandomSource)p_32354_) && flag;
    }

    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }

    protected PathNavigation createNavigation(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }
}

