/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;

public class BoulderingDrowned
extends Drowned {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(BoulderingDrowned.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected final WaterBoundPathNavigation waterNavigation;
    protected final WallClimberNavigation groundNavigation;
    boolean searchingForLand;

    public BoulderingDrowned(EntityType<? extends BoulderingDrowned> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, p_34272_);
        this.groundNavigation = new WallClimberNavigation((Mob)this, p_34272_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, (double)0.22f).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 3.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.getTarget();
        return livingentity != null && livingentity.isInWater();
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isInWater() && this.wantsToSwim()) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.groundNavigation;
                this.setSwimming(false);
            }
        }
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_218953_, DifficultyInstance p_218954_) {
        if ((double)p_218953_.nextFloat() > 0.9) {
            int i = p_218953_.nextInt(16);
            if (i < 10) {
                Registry registry = this.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                ItemStack stack = new ItemStack((ItemLike)Items.TRIDENT);
                stack.enchant((Holder)registry.getHolderOrThrow(Enchantments.RIPTIDE), 1);
                this.setItemSlot(EquipmentSlot.MAINHAND, stack);
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.FISHING_ROD));
            }
        }
    }

    public static boolean checkBoulderingDrownedSpawnRules(EntityType<BoulderingDrowned> p_32350_, ServerLevelAccessor p_32351_, MobSpawnType p_32352_, BlockPos p_32353_, RandomSource p_32354_) {
        boolean flag;
        if (!p_32351_.getFluidState(p_32353_.below()).is(FluidTags.WATER)) {
            return false;
        }
        Holder holder = p_32351_.getBiome(p_32353_);
        boolean bl = flag = p_32351_.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.isSpawner((MobSpawnType)p_32352_) || p_32351_.getFluidState(p_32353_).is(FluidTags.WATER) && BoulderingDrowned.isDarkEnoughToSpawn((ServerLevelAccessor)p_32351_, (BlockPos)p_32353_, (RandomSource)p_32354_));
        if (!holder.is(Biomes.RIVER) && !holder.is(Biomes.FROZEN_RIVER)) {
            return p_32354_.nextInt(40) == 0 && BoulderingDrowned.isDeepEnoughToSpawn((LevelAccessor)p_32351_, p_32353_) && flag;
        }
        return p_32354_.nextInt(15) == 0 && flag;
    }

    private static boolean isDeepEnoughToSpawn(LevelAccessor p_32367_, BlockPos p_32368_) {
        return p_32368_.getY() < p_32367_.getSeaLevel() - 5;
    }

    public void performRangedAttack(LivingEntity p_32356_, float p_32357_) {
        if (this.distanceToSqr((Entity)p_32356_) < 42.0) {
            Registry registry = this.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            int j = EnchantmentHelper.getEnchantmentLevel((Holder)registry.getHolderOrThrow(Enchantments.RIPTIDE), (LivingEntity)this);
            if (j > 0) {
                double f1 = p_32356_.getX() - this.getX();
                double f2 = p_32356_.getY() - this.getY();
                double f3 = p_32356_.getZ() - this.getZ();
                float f4 = Mth.sqrt((float)((float)(f1 * f1 + f2 * f2 + f3 * f3)));
                float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                this.push(f1 *= (double)(f5 / f4), f2 *= (double)(f5 / f4), f3 *= (double)(f5 / f4));
                this.startAutoSpinAttack(30);
                if (this.onGround()) {
                    float f6 = 1.1999999f;
                    this.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                SoundEvent soundevent = (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_1.value();
                this.playSound(soundevent, 1.0f, 1.0f);
            }
        } else {
            super.performRangedAttack(p_32356_, p_32357_);
        }
    }

    public void travel(Vec3 p_32394_) {
        if (this.isControlledByLocalInstance() && this.isInWater() && this.wantsToSwim()) {
            this.moveRelative(0.0175f, p_32394_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(p_32394_);
        }
    }

    public void startAutoSpinAttack(int p_204080_) {
        this.autoSpinAttackTicks = p_204080_;
        if (!this.level().isClientSide) {
            this.setLivingEntityFlag(4, true);
        }
    }

    protected void doAutoAttackOnTouch(LivingEntity p_36355_) {
        p_36355_.hurt(this.damageSources().mobAttack((LivingEntity)this), 9.0f);
    }
}

