/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.EarthMobsMod;
import baguchan.earthmobsmod.entity.goal.RangedAndMeleeAttack;
import baguchan.earthmobsmod.entity.projectile.BoneShard;
import baguchan.earthmobsmod.registry.ModEffects;
import baguchan.earthmobsmod.registry.ModEntityDatas;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class BoneSpider
extends Spider
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_STRAY_CONVERSION_ID = SynchedEntityData.defineId(BoneSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<PotionContents> DATA_POTION = SynchedEntityData.defineId(BoneSpider.class, (EntityDataSerializer)((EntityDataSerializer)ModEntityDatas.POTIONS.get()));
    private static final ColorParticleOption DEFAULT_PARTICLE = ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1);

    public BoneSpider(EntityType<? extends BoneSpider> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
        this.xpReward = 10;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STRAY_CONVERSION_ID, (Object)false);
        builder.define(DATA_POTION, (Object)PotionContents.EMPTY);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ARMOR, 10.0).add(Attributes.FOLLOW_RANGE, 18.0);
    }

    public void setPotionContents(PotionContents p_330869_) {
        this.entityData.set(DATA_POTION, (Object)p_330869_);
    }

    public PotionContents getPotionContents() {
        return (PotionContents)this.entityData.get(DATA_POTION);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new BoneSpiderAttackGoal(this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new SpiderTargetGoal<Player>(this, Player.class));
        this.targetSelector.addGoal(3, new SpiderTargetGoal<IronGolem>(this, IronGolem.class));
    }

    public boolean isFreezeConverting() {
        return (Boolean)this.getEntityData().get(DATA_STRAY_CONVERSION_ID);
    }

    public void setFreezeConverting(boolean p_149843_) {
        this.entityData.set(DATA_STRAY_CONVERSION_ID, (Object)p_149843_);
    }

    public boolean isShaking() {
        return this.isFreezeConverting();
    }

    public void tick() {
        if (this.level().isClientSide()) {
            for (int j = 0; j < 2; ++j) {
                int i = FastColor.ARGB32.opaque((int)this.getPotionContents().getColor());
                double d0 = this.getX();
                double d1 = this.getY();
                double d2 = this.getZ();
                this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)DEFAULT_PARTICLE.getType(), (int)i), d0, d1, d2, (0.5 - this.random.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.random.nextDouble()) * 0.15);
            }
        }
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag p_149836_) {
        super.addAdditionalSaveData(p_149836_);
        RegistryOps registryops = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (!this.getPotionContents().equals((Object)PotionContents.EMPTY)) {
            Tag tag = (Tag)PotionContents.CODEC.encodeStart((DynamicOps)registryops, (Object)this.getPotionContents()).getOrThrow();
            p_149836_.put("potion_contents", tag);
        }
    }

    public void readAdditionalSaveData(CompoundTag p_149833_) {
        super.readAdditionalSaveData(p_149833_);
        RegistryOps registryops = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (p_149833_.contains("potion_contents")) {
            PotionContents.CODEC.parse((DynamicOps)registryops, (Object)p_149833_.get("potion_contents")).resultOrPartial(p_340707_ -> EarthMobsMod.LOGGER.warn("Failed to parse potions: '{}'", p_340707_)).ifPresent(this::setPotionContents);
        }
    }

    public boolean canFreeze() {
        return false;
    }

    public boolean isInvertedHealAndHarm() {
        return true;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_478692_, DifficultyInstance p_479487_, MobSpawnType p_481376_, @Nullable SpawnGroupData p_480575_) {
        p_480575_ = super.finalizeSpawn(p_478692_, p_479487_, p_481376_, p_480575_);
        RandomSource randomsource = p_478692_.getRandom();
        if (randomsource.nextFloat() < 0.01f) {
            int i = randomsource.nextInt(4);
            MobEffectInstance mobEffect = i == 0 ? new MobEffectInstance(ModEffects.UNDEAD_BODY, 400, 0) : (i == 1 ? new MobEffectInstance(ModEffects.ZOMBIFIED, 200, 0) : (i == 2 ? new MobEffectInstance(MobEffects.SLOW_FALLING, 200, 0) : (i == 3 ? new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1, 0) : new MobEffectInstance(MobEffects.POISON, 60, 0))));
            this.setPotionContents(this.getPotionContents().withEffectAdded(mobEffect));
        }
        return p_480575_;
    }

    public void performRangedAttack(LivingEntity p_29912_, float p_29913_) {
        BoneShard bone = new BoneShard(this.level(), (LivingEntity)this);
        double x = p_29912_.getX() - this.getX();
        double y = p_29912_.getEyeY() - this.getEyeY();
        double z = p_29912_.getZ() - this.getZ();
        double length = Math.sqrt(x * x + z * z);
        bone.shoot(x, y + length * (double)0.275f, z, 0.75f, 2.0f);
        PotionContents collection = this.getPotionContents();
        if (collection.hasEffects()) {
            for (MobEffectInstance mobEffectInstance : this.getPotionContents().getAllEffects()) {
                bone.addEffect(new MobEffectInstance(mobEffectInstance.getEffect(), mobEffectInstance.getDuration(), 0));
            }
        }
        this.level().addFreshEntity((Entity)bone);
    }

    public float getScale() {
        return this.isBaby() ? 0.6f : 1.0f;
    }

    static class BoneSpiderAttackGoal
    extends RangedAndMeleeAttack {
        private final BoneSpider spider;

        public BoneSpiderAttackGoal(BoneSpider p_32247_) {
            super(p_32247_, 1.0, 40, 80.0f, 14);
            this.spider = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public void tick() {
            super.tick();
            if (this.attackTime == 15) {
                this.spider.playSound(SoundEvents.LLAMA_SPIT, this.spider.getSoundVolume(), 0.4f / (this.spider.getRandom().nextFloat() * 0.4f + 0.8f));
            }
        }

        @Override
        public boolean canUse() {
            return super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            float f = this.mob.getLightLevelDependentMagicValue();
            if (f >= 0.5f && this.mob.getRandom().nextInt(100) == 0) {
                this.mob.setTarget((LivingEntity)null);
                return false;
            }
            return super.canContinueToUse();
        }

        @Override
        protected double getAttackReachSqr(LivingEntity p_33825_) {
            return 4.0f + p_33825_.getBbWidth();
        }
    }

    static class SpiderTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public SpiderTargetGoal(Spider p_33832_, Class<T> p_33833_) {
            super((Mob)p_33832_, p_33833_, true);
        }

        public boolean canUse() {
            float f = this.mob.getLightLevelDependentMagicValue();
            return f >= 0.5f ? false : super.canUse();
        }
    }
}

