/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.render.layer;

import baguchan.earthmobsmod.api.IMuddyPig;
import baguchan.earthmobsmod.api.ISheared;
import baguchan.earthmobsmod.client.ModModelLayers;
import baguchan.earthmobsmod.client.model.MuddyPigModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MuddyPigFlowerLayer
extends RenderLayer<Pig, PigModel<Pig>> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/muddypig/pig_muddy_flower.png");
    private final MuddyPigModel<Pig> model;

    public MuddyPigFlowerLayer(RenderLayerParent<Pig, PigModel<Pig>> p_174533_, EntityModelSet p_174534_) {
        super(p_174533_);
        this.model = new MuddyPigModel(p_174534_.bakeLayer(ModModelLayers.MUDDY_PIG));
    }

    public void render(PoseStack p_117421_, MultiBufferSource p_117422_, int p_117423_, Pig pig, float p_117425_, float p_117426_, float p_117427_, float p_117428_, float p_117429_, float p_117430_) {
        if (pig instanceof IMuddyPig && pig instanceof ISheared && ((IMuddyPig)pig).isMuddy() && !((ISheared)pig).isSheared()) {
            if (pig.isInvisible()) {
                Minecraft minecraft = Minecraft.getInstance();
                boolean j = minecraft.shouldEntityAppearGlowing((Entity)pig);
                if (j) {
                    ((PigModel)this.getParentModel()).copyPropertiesTo(this.model);
                    this.model.prepareMobModel((Entity)pig, p_117425_, p_117426_, p_117427_);
                    this.model.setupAnim(pig, p_117425_, p_117426_, p_117428_, p_117429_, p_117430_);
                    VertexConsumer vertexconsumer = p_117422_.getBuffer(RenderType.outline((ResourceLocation)LOCATION));
                    this.model.renderToBuffer(p_117421_, vertexconsumer, p_117423_, LivingEntityRenderer.getOverlayCoords((LivingEntity)pig, (float)0.0f), FastColor.ARGB32.colorFromFloat((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
                }
            } else {
                int i;
                if (pig.hasCustomName() && "jeb_".equals(pig.getName().getString())) {
                    boolean j = true;
                    int k = pig.tickCount / 25 + pig.getId();
                    int l = DyeColor.values().length;
                    int i1 = k % l;
                    int j1 = (k + 1) % l;
                    float f = ((float)(pig.tickCount % 25) + p_117427_) / 25.0f;
                    int k1 = Sheep.getColor((DyeColor)DyeColor.byId((int)i1));
                    int l1 = Sheep.getColor((DyeColor)DyeColor.byId((int)j1));
                    i = FastColor.ARGB32.lerp((float)f, (int)k1, (int)l1);
                } else {
                    i = Sheep.getColor((DyeColor)((ISheared)pig).getColor());
                }
                MuddyPigFlowerLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.model, (ResourceLocation)LOCATION, (PoseStack)p_117421_, (MultiBufferSource)p_117422_, (int)p_117423_, (LivingEntity)pig, (float)p_117425_, (float)p_117426_, (float)p_117428_, (float)p_117429_, (float)p_117430_, (float)p_117427_, (int)i);
            }
        }
    }
}

