/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.render;

import baguchan.earthmobsmod.entity.TropicalSlime;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ColorableHierarchicalModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.TropicalFishModelA;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TropicalSlimeRenderer
extends MobRenderer<Slime, SlimeModel<Slime>> {
    private static final ResourceLocation SLIME_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"textures/entity/tropical_slime/tropical_slime.png");
    private static final ResourceLocation[] BASE_TEXTURE_LOCATIONS = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_a.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_b.png")};
    private static final ResourceLocation[] PATTERN_A_TEXTURE_LOCATIONS = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_a_pattern_1.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_a_pattern_2.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_a_pattern_3.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_a_pattern_4.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_a_pattern_5.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_a_pattern_6.png")};
    private static final ResourceLocation[] PATTERN_B_TEXTURE_LOCATIONS = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_b_pattern_1.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_b_pattern_2.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_b_pattern_3.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_b_pattern_4.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_b_pattern_5.png"), ResourceLocation.withDefaultNamespace((String)"textures/entity/fish/tropical_b_pattern_6.png")};
    private final ColorableHierarchicalModel modelA;
    private final ColorableHierarchicalModel modelB;
    private final ColorableHierarchicalModel patternModelA;
    private final ColorableHierarchicalModel patternModelB;

    public TropicalSlimeRenderer(EntityRendererProvider.Context p_174391_) {
        super(p_174391_, (EntityModel)new SlimeModel(p_174391_.bakeLayer(ModelLayers.SLIME)), 0.25f);
        this.addLayer((RenderLayer)new SlimeOuterLayer((RenderLayerParent)this, p_174391_.getModelSet()));
        this.modelA = new TropicalFishModelA(p_174391_.bakeLayer(ModelLayers.TROPICAL_FISH_SMALL));
        this.modelB = new TropicalFishModelB(p_174391_.bakeLayer(ModelLayers.TROPICAL_FISH_LARGE));
        this.patternModelA = new TropicalFishModelA(p_174391_.bakeLayer(ModelLayers.TROPICAL_FISH_SMALL_PATTERN));
        this.patternModelB = new TropicalFishModelB(p_174391_.bakeLayer(ModelLayers.TROPICAL_FISH_LARGE_PATTERN));
    }

    public void render(Slime p_115976_, float p_115977_, float p_115978_, PoseStack p_115979_, MultiBufferSource p_115980_, int p_115981_) {
        this.shadowRadius = 0.25f * (float)p_115976_.getSize();
        if (p_115976_ instanceof TropicalSlime) {
            this.renderFish((TropicalSlime)p_115976_, p_115978_, p_115979_, p_115980_, p_115981_);
        }
        super.render((LivingEntity)p_115976_, p_115977_, p_115978_, p_115979_, p_115980_, p_115981_);
    }

    public static int getBaseVariant(int p_30059_) {
        return Math.min(p_30059_ & 0xFF, 1);
    }

    private static int getBaseColorIdx(int p_30061_) {
        return (p_30061_ & 0xFF0000) >> 16;
    }

    public int getBaseColor(int variant) {
        return DyeColor.byId((int)TropicalSlimeRenderer.getBaseColorIdx(variant)).getTextureDiffuseColor();
    }

    private static int getPatternColorIdx(int p_30063_) {
        return (p_30063_ & 0xFF000000) >> 24;
    }

    public int getPatternColor(int variant) {
        return DyeColor.byId((int)TropicalSlimeRenderer.getPatternColorIdx(variant)).getTextureDiffuseColor();
    }

    public ResourceLocation getPatternTextureLocation(int variant) {
        return TropicalSlimeRenderer.getBaseVariant(variant) == 0 ? PATTERN_A_TEXTURE_LOCATIONS[TropicalSlimeRenderer.getPatternVariant(variant)] : PATTERN_B_TEXTURE_LOCATIONS[TropicalSlimeRenderer.getPatternVariant(variant)];
    }

    public ResourceLocation getBaseTextureLocation(int variant) {
        return BASE_TEXTURE_LOCATIONS[TropicalSlimeRenderer.getBaseVariant(variant)];
    }

    private static int getPatternVariant(int p_30065_) {
        return Math.min((p_30065_ & 0xFF00) >> 8, 5);
    }

    public void renderFish(TropicalSlime parent, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        CompoundTag compoundTag = parent.getFishData();
        int i = parent.getSize();
        ListTag listTag = (ListTag)compoundTag.get("FishList");
        if (compoundTag != null && listTag != null) {
            float f = (float)i / 3.0f;
            for (int l = 0; l < listTag.size(); ++l) {
                double f1 = ((CompoundTag)listTag.get(l)).getDouble("FishPosX");
                double f2 = ((CompoundTag)listTag.get(l)).getDouble("FishPosZ");
                int variant = ((CompoundTag)listTag.get(l)).getInt("FishVariant");
                ColorableHierarchicalModel basemodel = TropicalSlimeRenderer.getBaseVariant(((CompoundTag)listTag.get(l)).getInt("FishVariant")) == 0 ? this.modelA : this.modelB;
                ColorableHierarchicalModel patternModel = TropicalSlimeRenderer.getPatternVariant(((CompoundTag)listTag.get(l)).getInt("FishVariant")) == 0 ? this.patternModelA : this.patternModelB;
                double fishInX = Mth.lerp((double)partialTicks, (double)(parent.xOld + f1), (double)(parent.getX() + f1)) - Mth.lerp((double)partialTicks, (double)parent.xOld, (double)parent.getX());
                double fishInY = ((CompoundTag)listTag.get(l)).getDouble("FishPosY");
                double fishInZ = Mth.lerp((double)partialTicks, (double)(parent.zOld + f2), (double)(parent.getZ() + f2)) - Mth.lerp((double)partialTicks, (double)parent.zOld, (double)parent.getZ());
                stack.pushPose();
                VertexConsumer vertexConsumer = buffer.getBuffer(basemodel.renderType(this.getBaseTextureLocation(variant)));
                int afloat = this.getBaseColor(variant);
                basemodel.setColor(afloat);
                stack.translate(fishInX, fishInY, fishInZ);
                stack.scale(-1.0f, -1.0f, 1.0f);
                stack.translate(0.0f, -1.501f, 0.0f);
                basemodel.setupAnim((Entity)parent, 0.0f, 0.0f, this.getBob((LivingEntity)parent, partialTicks), 0.0f, 0.0f);
                basemodel.renderToBuffer(stack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
                basemodel.setColor(0xFFFFFF);
                stack.popPose();
                stack.pushPose();
                VertexConsumer vertexConsumer2 = buffer.getBuffer(basemodel.renderType(this.getPatternTextureLocation(variant)));
                int afloat2 = this.getPatternColor(variant);
                patternModel.setColor(afloat2);
                stack.translate(fishInX, fishInY, fishInZ);
                stack.scale(-1.0f, -1.0f, 1.0f);
                stack.translate(0.0f, -1.501f, 0.0f);
                patternModel.setupAnim((Entity)parent, 0.0f, 0.0f, this.getBob((LivingEntity)parent, partialTicks), 0.0f, 0.0f);
                patternModel.renderToBuffer(stack, vertexConsumer2, light, OverlayTexture.NO_OVERLAY);
                basemodel.setColor(0xFFFFFF);
                stack.popPose();
            }
        }
    }

    protected void scale(Slime p_115983_, PoseStack p_115984_, float p_115985_) {
        float f = 0.999f;
        p_115984_.scale(0.999f, 0.999f, 0.999f);
        p_115984_.translate(0.0, (double)0.001f, 0.0);
        float f1 = p_115983_.getSize();
        float f2 = Mth.lerp((float)p_115985_, (float)p_115983_.oSquish, (float)p_115983_.squish) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        p_115984_.scale(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public ResourceLocation getTextureLocation(Slime p_115974_) {
        return SLIME_LOCATION;
    }
}

