/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.api.IMuddyPig;
import baguchan.earthmobsmod.entity.TeaCupPig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class TeaCupPigModel<T extends TeaCupPig>
extends EntityModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;

    public TeaCupPigModel(ModelPart root) {
        this.root = root.getChild("root");
        this.head = this.root.getChild("head");
        this.body = this.root.getChild("body");
        this.leg0 = this.root.getChild("leg0");
        this.leg1 = this.root.getChild("leg1");
        this.leg2 = this.root.getChild("leg2");
        this.leg3 = this.root.getChild("leg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -3.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(14, 0).addBox(-1.5f, -1.0f, -5.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)-1.5f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 8).addBox(-2.0f, -6.0f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)1.5f));
        PartDefinition leg0 = root.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(14, 8).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.0f, (float)3.5f));
        PartDefinition leg4 = root.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(14, 8).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.0f, (float)-0.5f));
        PartDefinition leg2 = root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(14, 8).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.0f, (float)3.5f));
        PartDefinition leg3 = root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(14, 8).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.0f, (float)-0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void prepareMobModel(T p_104132_, float p_104133_, float p_104134_, float p_104135_) {
        super.prepareMobModel(p_104132_, p_104133_, p_104134_, p_104135_);
        if (p_104132_ instanceof IMuddyPig) {
            this.body.zRot = ((IMuddyPig)p_104132_).getBodyRollAngle(p_104135_, -0.16f);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.leg0.xRot = Mth.cos((float)(limbSwing * 0.68f)) * 1.4f * limbSwingAmount;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.68f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.68f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 0.68f)) * 1.4f * limbSwingAmount;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
        this.root.render(poseStack, vertexConsumer, i, i1, i2);
    }
}

