/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.api.ISheared;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class MuddyPigModel<T extends Entity>
extends PigModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart mud;
    private final ModelPart flower;

    public MuddyPigModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.mud = this.head.getChild("mud");
        this.flower = this.mud.getChild("flower");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation p_170801_) {
        MeshDefinition meshdefinition = QuadrupedModel.createBodyMesh((int)6, (CubeDeformation)p_170801_);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, p_170801_).texOffs(16, 16).addBox(-2.0f, 0.0f, -9.0f, 4.0f, 3.0f, 1.0f, p_170801_), PartPose.offset((float)0.0f, (float)12.0f, (float)-6.0f));
        PartDefinition mud = head.addOrReplaceChild("mud", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, -1.0f, 0.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-4.0f, (float)-7.0f));
        PartDefinition flower = mud.addOrReplaceChild("flower", CubeListBuilder.create().texOffs(20, 0).addBox(-3.0f, 0.0f, 0.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity instanceof ISheared) {
            this.flower.visible = !((ISheared)entity).isSheared();
        }
    }
}

