/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.entity.MagmaCow;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MagmaCowModel<T extends MagmaCow>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart body;
    private float headXRot;

    public MagmaCowModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createAnimateBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(35, 23).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(4.0f, -3.0f, -3.0f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(-9.0f, -3.0f, -3.0f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(41, 50).addBox(7.0f, -6.0f, -3.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(41, 50).mirror().addBox(-9.0f, -6.0f, -3.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)4.0f, (float)-9.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(45, 38).addBox(-2.0f, 2.75f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(41, 12).addBox(-2.0f, 3.5f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(41, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)14.0f, (float)7.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(45, 38).addBox(-2.0f, 2.75f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(41, 12).addBox(-2.0f, 3.5f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(41, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)14.0f, (float)7.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(45, 38).addBox(-2.0f, 2.75f, -1.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(41, 0).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(41, 12).addBox(-2.0f, 3.5f, -1.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-3.0f, (float)14.0f, (float)-6.0f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(45, 38).addBox(-2.0f, 2.75f, -1.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(41, 12).addBox(-2.0f, 3.5f, -1.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(41, 0).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)14.0f, (float)-6.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -8.0f, 10.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-6.0f, -11.0f, -5.0f, 12.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(15, 51).addBox(-2.0f, 2.0f, -9.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(35, 23).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(4.0f, -3.0f, -3.0f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(-9.0f, -3.0f, -3.0f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(41, 50).addBox(7.0f, -6.0f, -3.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(41, 50).mirror().addBox(-9.0f, -6.0f, -3.0f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)4.0f, (float)-9.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(45, 38).addBox(-2.0f, 2.75f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(41, 12).addBox(-2.0f, 3.5f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(41, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)14.0f, (float)7.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(45, 38).addBox(-2.0f, 2.75f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(41, 12).addBox(-2.0f, 3.5f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(41, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)14.0f, (float)7.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(45, 38).addBox(-2.0f, 2.75f, -1.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(41, 0).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(41, 12).addBox(-2.0f, 3.5f, -1.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-3.0f, (float)14.0f, (float)-6.0f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(45, 38).addBox(-2.0f, 2.75f, -1.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).texOffs(41, 12).addBox(-2.0f, 3.5f, -1.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(41, 0).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)14.0f, (float)-6.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -8.0f, 10.0f, 18.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-6.0f, -11.0f, -5.0f, 12.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(15, 51).addBox(-2.0f, 2.0f, -9.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.68f)) * 1.4f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.68f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 0.68f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 0.68f)) * 1.4f * limbSwingAmount;
        this.head.xRot = this.headXRot;
    }

    public void prepareMobModel(T p_103687_, float p_103688_, float p_103689_, float p_103690_) {
        super.prepareMobModel(p_103687_, p_103688_, p_103689_, p_103690_);
        this.headXRot = ((MagmaCow)((Object)p_103687_)).getHeadEatAngleScale(p_103690_);
        if (this.attackTime > 0.0f) {
            this.headXRot = -0.95f * Mth.sin((float)(this.attackTime * (float)Math.PI));
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        if (this.young) {
            poseStack.pushPose();
            float f = 0.75f;
            poseStack.scale(f, f, f);
            poseStack.translate(0.0f, 0.9375f, 0.25f);
            this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.translate(0.0f, 1.5f, 0.0f);
            this.leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            poseStack.popPose();
        } else {
            poseStack.pushPose();
            this.leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
            poseStack.popPose();
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

