/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.entity.JumboRabbit;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class JumboRabbitModel<T extends JumboRabbit>
extends EntityModel<T> {
    private final ModelPart rearFootRight;
    private final ModelPart rearFootLeft;
    private final ModelPart haunchRight;
    private final ModelPart haunchLeft;
    private final ModelPart body;
    private final ModelPart frontLegRight;
    private final ModelPart frontLegLeft;
    private final ModelPart head;
    private final ModelPart earLeft;
    private final ModelPart earRight;
    private final ModelPart tail;
    private final ModelPart nose;
    private float jumpRotation;

    public JumboRabbitModel(ModelPart root) {
        this.rearFootRight = root.getChild("rearFootRight");
        this.rearFootLeft = root.getChild("rearFootLeft");
        this.haunchRight = root.getChild("haunchRight");
        this.haunchLeft = root.getChild("haunchLeft");
        this.body = root.getChild("body");
        this.frontLegRight = root.getChild("frontLegRight");
        this.frontLegLeft = root.getChild("frontLegLeft");
        this.head = root.getChild("head");
        this.earLeft = root.getChild("earLeft");
        this.earRight = root.getChild("earRight");
        this.tail = root.getChild("tail");
        this.nose = root.getChild("nose");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rearFootRight = partdefinition.addOrReplaceChild("rearFootRight", CubeListBuilder.create().texOffs(20, 34).addBox(-3.0f, 5.5f, -3.7f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)17.5f, (float)3.7f));
        PartDefinition rearFootLeft = partdefinition.addOrReplaceChild("rearFootLeft", CubeListBuilder.create().texOffs(0, 34).addBox(0.0f, 5.5f, -3.7f, 3.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)17.5f, (float)3.7f));
        PartDefinition haunchRight = partdefinition.addOrReplaceChild("haunchRight", CubeListBuilder.create().texOffs(38, 22).addBox(-3.0f, -3.0f, 0.0f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)17.5f, (float)3.7f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition haunchLeft = partdefinition.addOrReplaceChild("haunchLeft", CubeListBuilder.create().texOffs(22, 22).addBox(0.0f, -3.0f, 0.0f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)17.5f, (float)3.7f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -14.0f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)8.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition frontLegRight = partdefinition.addOrReplaceChild("frontLegRight", CubeListBuilder.create().texOffs(0, 47).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)17.0f, (float)-5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition frontLegLeft = partdefinition.addOrReplaceChild("frontLegLeft", CubeListBuilder.create().texOffs(40, 34).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)17.0f, (float)-5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-2.5f, -5.0f, -6.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)-4.0f));
        PartDefinition earLeft = partdefinition.addOrReplaceChild("earLeft", CubeListBuilder.create().texOffs(6, 60).addBox(0.5f, -7.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-5.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition earLeft2 = earLeft.addOrReplaceChild("earLeft2", CubeListBuilder.create().texOffs(16, 47).addBox(0.0f, -10.0f, -0.1f, 3.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-7.0f, (float)-1.0f));
        PartDefinition earRight = partdefinition.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(0, 60).addBox(-2.5f, -6.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)-5.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition earRight2 = earRight.addOrReplaceChild("earRight2", CubeListBuilder.create().texOffs(8, 47).addBox(-3.5f, -13.0f, -1.0f, 3.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(24, 47).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)7.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition nose = partdefinition.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(12, 60).addBox(-0.5f, -2.5f, -6.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((JumboRabbit)((Object)entity)).tickCount;
        this.nose.xRot = headPitch * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.earLeft.xRot = headPitch * ((float)Math.PI / 180);
        this.earRight.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.nose.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.earLeft.yRot = this.nose.yRot + 0.2617994f;
        this.earRight.yRot = this.nose.yRot - 0.2617994f;
        this.jumpRotation = Mth.sin((float)(entity.getJumpCompletion(f) * (float)Math.PI));
        this.haunchRight.xRot = -0.1745f + (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.haunchLeft.xRot = -0.1745f + (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rearFootRight.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rearFootLeft.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.frontLegRight.xRot = -0.1745f + this.jumpRotation * -29.0f * ((float)Math.PI / 180);
        this.frontLegLeft.xRot = -0.1745f + this.jumpRotation * -29.0f * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
        this.rearFootRight.render(poseStack, vertexConsumer, i, i1, i2);
        this.rearFootLeft.render(poseStack, vertexConsumer, i, i1, i2);
        this.haunchRight.render(poseStack, vertexConsumer, i, i1, i2);
        this.haunchLeft.render(poseStack, vertexConsumer, i, i1, i2);
        this.body.render(poseStack, vertexConsumer, i, i1, i2);
        this.frontLegRight.render(poseStack, vertexConsumer, i, i1, i2);
        this.frontLegLeft.render(poseStack, vertexConsumer, i, i1, i2);
        this.head.render(poseStack, vertexConsumer, i, i1, i2);
        this.earLeft.render(poseStack, vertexConsumer, i, i1, i2);
        this.earRight.render(poseStack, vertexConsumer, i, i1, i2);
        this.tail.render(poseStack, vertexConsumer, i, i1, i2);
        this.nose.render(poseStack, vertexConsumer, i, i1, i2);
    }
}

