/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import baguchan.earthmobsmod.entity.FurnaceGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class FurnaceGolemModel<T extends FurnaceGolem>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart head2;

    public FurnaceGolemModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
        this.head2 = root.getChild("head2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-4.0f, -12.0f, -7.5f, 8.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-2.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 40).addBox(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 70).addBox(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(60, 21).addBox(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(60, 58).addBox(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(37, 0).addBox(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)11.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(60, 0).addBox(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)11.0f, (float)0.0f));
        PartDefinition head2 = partdefinition.addOrReplaceChild("head2", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(32, 22).addBox(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 26).addBox(-4.0f, -12.0f, -7.5f, 8.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T p_102962_, float p_102963_, float p_102964_, float p_102965_, float p_102966_, float p_102967_) {
        this.head.yRot = p_102966_ * ((float)Math.PI / 180);
        this.head.xRot = p_102967_ * ((float)Math.PI / 180);
        this.right_leg.xRot = -1.5f * Mth.triangleWave((float)p_102963_, (float)13.0f) * p_102964_;
        this.left_leg.xRot = 1.5f * Mth.triangleWave((float)p_102963_, (float)13.0f) * p_102964_;
        this.right_leg.yRot = 0.0f;
        this.left_leg.yRot = 0.0f;
        this.head2.copyFrom(this.head);
    }

    public void prepareMobModel(T p_102957_, float p_102958_, float p_102959_, float p_102960_) {
        int i = ((FurnaceGolem)((Object)p_102957_)).getAttackAnimationTick();
        this.head2.visible = ((FurnaceGolem)((Object)p_102957_)).isFurnaceActive();
        if (i > 0) {
            this.right_arm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - p_102960_), (float)10.0f);
            this.left_arm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)i - p_102960_), (float)10.0f);
        } else if (((FurnaceGolem)((Object)p_102957_)).isFurnaceActive()) {
            this.right_arm.xRot = -0.8f;
            this.left_arm.xRot = -0.8f;
        } else {
            this.right_arm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)p_102958_, (float)13.0f)) * p_102959_;
            this.left_arm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)p_102958_, (float)13.0f)) * p_102959_;
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

