/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client.model;

import bagu_chan.bagus_lib.client.layer.IArmor;
import baguchan.earthmobsmod.client.animation.BabyZombieAnimation;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.Zombie;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractBoulderingZombieModel<T extends Zombie>
extends HierarchicalModel<T>
implements IArmor,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bone;
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public AbstractBoulderingZombieModel(ModelPart root) {
        this.root = root;
        this.bone = root.getChild("bone");
        this.head = this.bone.getChild("head");
        this.body = this.bone.getChild("body");
        this.left_arm = this.bone.getChild("left_arm");
        this.right_arm = this.bone.getChild("right_arm");
        this.left_leg = this.bone.getChild("left_leg");
        this.right_leg = this.bone.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = bone.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition body = bone.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(28, 28).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition left_arm = bone.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 48).addBox(-1.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-1.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition right_arm = bone.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(38, 44).addBox(-4.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(20, 44).addBox(-4.0f, -2.0f, -2.0f, 5.0f, 14.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition left_leg = bone.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(60, 0).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(52, 30).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)1.9f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = bone.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(56, 46).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(48, 14).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-1.9f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        AnimationUtils.animateZombieArms((ModelPart)this.left_arm, (ModelPart)this.right_arm, (boolean)entity.isAggressive(), (float)this.attackTime, (float)ageInTicks);
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.right_leg.yRot = 0.0f;
        this.right_leg.zRot = 0.0f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.left_leg.yRot = 0.0f;
        this.left_leg.zRot = 0.0f;
        if (entity.onClimbable()) {
            this.left_arm.xRot -= Mth.sin((float)(0.25f * ageInTicks)) * 0.225f;
            this.right_arm.xRot += Mth.sin((float)(0.25f * ageInTicks)) * 0.225f;
            this.left_leg.xRot = -0.4f - Mth.sin((float)(0.25f * ageInTicks)) * 0.225f;
            this.right_leg.xRot = -0.4f + Mth.sin((float)(0.25f * ageInTicks)) * 0.225f;
        }
        if (entity.isBaby()) {
            this.applyStatic(BabyZombieAnimation.baby);
        }
    }

    protected float rotlerpRad(float angle, float maxAngle, float mul) {
        float f = (mul - maxAngle) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngle + angle * f;
    }

    public ModelPart root() {
        return this.root;
    }

    public void translateToHead(ModelPart part, PoseStack poseStack) {
        this.bone.translateAndRotate(poseStack);
        part.translateAndRotate(poseStack);
    }

    public void translateToChest(ModelPart part, PoseStack poseStack) {
        this.bone.translateAndRotate(poseStack);
        part.translateAndRotate(poseStack);
    }

    public void translateToLeg(ModelPart part, PoseStack poseStack) {
        this.bone.translateAndRotate(poseStack);
        part.translateAndRotate(poseStack);
    }

    public void translateToChestPat(ModelPart part, PoseStack poseStack) {
        this.bone.translateAndRotate(poseStack);
        part.translateAndRotate(poseStack);
        poseStack.scale(1.05f, 1.05f, 1.05f);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.right_arm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.left_arm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.right_leg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.left_leg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }

    public void translateToHand(HumanoidArm p_102854_, PoseStack p_102855_) {
        this.getArm(p_102854_).translateAndRotate(p_102855_);
    }

    protected ModelPart getArm(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }
}

