/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.client;

import baguchan.earthmobsmod.capability.ShadowCapability;
import baguchan.earthmobsmod.entity.HyperRabbit;
import baguchan.earthmobsmod.registry.ModCapability;
import baguchan.earthmobsmod.registry.ModEffects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

@EventBusSubscriber(modid="earthmobsmod", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void renderEvent(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        MultiBufferSource buffer = event.getMultiBufferSource();
        LivingEntity entity = event.getEntity();
        LivingEntityRenderer renderer = event.getRenderer();
        PoseStack posestack = event.getPoseStack();
        int light = event.getPackedLight();
        float partialtick = event.getPartialTick();
        ShadowCapability shadowCapability = (ShadowCapability)event.getEntity().getData(ModCapability.SHADOW_ATTACH);
        if (shadowCapability != null && (entity instanceof HyperRabbit && ((HyperRabbit)entity).isSpark() || entity.hasEffect(ModEffects.HYPER_SPARK))) {
            Direction direction;
            Direction direction2;
            posestack.pushPose();
            boolean shouldSit = entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
            float f = Mth.rotLerp((float)partialtick, (float)entity.yBodyRotO, (float)entity.yBodyRot);
            float f1 = Mth.rotLerp((float)partialtick, (float)entity.yHeadRotO, (float)entity.yHeadRot);
            float f2 = f1 - f;
            if (shouldSit && entity.getVehicle() instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity.getVehicle();
                f = Mth.rotLerp((float)partialtick, (float)shadowCapability.yBodyRot, (float)livingentity.yBodyRot);
                f2 = f1 - f;
                float f3 = Mth.wrapDegrees((float)f2);
                if (f3 < -85.0f) {
                    f3 = -85.0f;
                }
                if (f3 >= 85.0f) {
                    f3 = 85.0f;
                }
                f = f1 - f3;
                if (f3 * f3 > 2500.0f) {
                    f += f3 * 0.2f;
                }
                f2 = f1 - f;
            }
            float f6 = Mth.lerp((float)partialtick, (float)entity.xRotO, (float)entity.getXRot());
            if (entity.getPose() == Pose.SLEEPING && (direction2 = entity.getBedOrientation()) != null) {
                float f4 = entity.getEyeHeight(Pose.STANDING) - 0.1f;
                posestack.translate((double)((float)(-direction2.getStepX()) * f4), 0.0, (double)((float)(-direction2.getStepZ()) * f4));
            }
            float f7 = ClientEvents.getBob(entity, partialtick);
            double shadowX = shadowCapability.prevShadowX + (shadowCapability.shadowX - shadowCapability.prevShadowX) * partialtick;
            double shadowY = shadowCapability.prevShadowY + (shadowCapability.shadowY - shadowCapability.prevShadowY) * partialtick;
            double shadowZ = shadowCapability.prevShadowZ + (shadowCapability.shadowZ - shadowCapability.prevShadowZ) * partialtick;
            double shadowX2 = shadowCapability.prevShadowX2 + (shadowCapability.shadowX2 - shadowCapability.prevShadowX2) * partialtick;
            double shadowY2 = shadowCapability.prevShadowY2 + (shadowCapability.shadowY2 - shadowCapability.prevShadowY2) * partialtick;
            double shadowZ2 = shadowCapability.prevShadowZ2 + (shadowCapability.shadowZ2 - shadowCapability.prevShadowZ2) * partialtick;
            double ownerInX = entity.xo + (entity.getX() - entity.xo) * (double)partialtick;
            double ownerInY = entity.yo + (entity.getY() - entity.yo) * (double)partialtick;
            double ownerInZ = entity.zo + (entity.getZ() - entity.zo) * (double)partialtick;
            double deltaX = shadowX - ownerInX;
            double deltaY = shadowY - ownerInY;
            double deltaZ = shadowZ - ownerInZ;
            double deltaX2 = shadowX2 - shadowX;
            double deltaY2 = shadowY2 - shadowY;
            double deltaZ2 = shadowZ2 - shadowZ;
            float yRotShadow = Mth.lerp((float)partialtick, (float)shadowCapability.prevYRot, (float)shadowCapability.yRot);
            float yRotShadow2 = Mth.lerp((float)partialtick, (float)shadowCapability.prevYRot2, (float)shadowCapability.yRot2);
            float ownerYRot = entity.yRotO + (entity.getYRot() - entity.yRotO) * partialtick;
            float yRot = yRotShadow - ownerYRot;
            float yRot2 = yRotShadow2 - yRotShadow;
            Pose pose = entity.getPose();
            posestack.translate(deltaX, deltaY, deltaZ);
            if (!entity.hasPose(Pose.SLEEPING)) {
                posestack.mulPose(Axis.YP.rotationDegrees(yRot));
                posestack.mulPose(Axis.YP.rotationDegrees(180.0f - f));
            }
            posestack.scale(-1.0f, -1.0f, 1.0f);
            posestack.translate(0.0, (double)-1.501f, 0.0);
            float f8 = 0.0f;
            float f5 = 0.0f;
            if (!shouldSit && entity.isAlive()) {
                f8 = entity.walkAnimation.speed(partialtick);
                f5 = entity.walkAnimation.position(partialtick);
                if (entity.isBaby()) {
                    f5 *= 3.0f;
                }
                if (f8 > 1.0f) {
                    f8 = 1.0f;
                }
            }
            renderer.getModel().prepareMobModel((Entity)entity, f5, f8, partialtick);
            renderer.getModel().setupAnim((Entity)entity, f5, f8, f7, f2, f6);
            VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)renderer.getTextureLocation((Entity)entity)));
            int i = LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f);
            renderer.getModel().renderToBuffer(posestack, vertexconsumer, light, i, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)114));
            posestack.popPose();
            posestack.pushPose();
            if (shouldSit && entity.getVehicle() instanceof LivingEntity) {
                f = Mth.rotLerp((float)partialtick, (float)shadowCapability.yBodyRot2, (float)shadowCapability.yBodyRot);
                f2 = f1 - f;
                float f3 = Mth.wrapDegrees((float)f2);
                if (f3 < -85.0f) {
                    f3 = -85.0f;
                }
                if (f3 >= 85.0f) {
                    f3 = 85.0f;
                }
                f = f1 - f3;
                if (f3 * f3 > 2500.0f) {
                    f += f3 * 0.2f;
                }
                f2 = f1 - f;
            }
            if (entity.getPose() == Pose.SLEEPING && (direction = entity.getBedOrientation()) != null) {
                float f4 = entity.getEyeHeight(Pose.STANDING) - 0.1f;
                posestack.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
            }
            posestack.translate(deltaX2, deltaY2, deltaZ2);
            if (!entity.hasPose(Pose.SLEEPING)) {
                posestack.mulPose(Axis.YP.rotationDegrees(yRot2));
                posestack.mulPose(Axis.YP.rotationDegrees(180.0f - f));
            }
            posestack.scale(-1.0f, -1.0f, 1.0f);
            posestack.translate(0.0, (double)-1.501f, 0.0);
            renderer.getModel().prepareMobModel((Entity)entity, f5, f8, partialtick);
            renderer.getModel().setupAnim((Entity)entity, f5, f8, f7, f2, f6);
            renderer.getModel().renderToBuffer(posestack, vertexconsumer, light, i, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)38));
            posestack.popPose();
        }
    }

    protected static float getBob(LivingEntity livingEntity, float partialTick) {
        return (float)livingEntity.tickCount + partialTick;
    }
}

