/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.capability;

import baguchan.earthmobsmod.registry.ModEffects;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.Nullable;

public class ShadowCapability
implements IAttachmentSerializer<CompoundTag, ShadowCapability> {
    private static final ResourceLocation SPEED_MODIFIER_BOOST_UUID = ResourceLocation.fromNamespaceAndPath((String)"earthmobsmod", (String)"shadow_speed");
    public float prevShadowX;
    public float prevShadowY;
    public float prevShadowZ;
    public float shadowX;
    public float shadowY;
    public float shadowZ;
    public float prevShadowX2;
    public float prevShadowY2;
    public float prevShadowZ2;
    public float shadowX2;
    public float shadowY2;
    public float shadowZ2;
    public float prevYBodyRot;
    public float yBodyRot;
    public float prevYBodyRot2;
    public float yBodyRot2;
    public float prevYRot;
    public float yRot;
    public float prevYRot2;
    public float yRot2;
    public float prevRotationPitch;
    public float xRot;
    public float prevRotationPitch2;
    public float xRot2;
    private float percentBoost;

    public void tick(LivingEntity livingEntity) {
        if (!livingEntity.level().isClientSide) {
            this.removeBoost(livingEntity);
        }
        double elasticity = 0.25;
        this.prevShadowX = this.shadowX;
        this.prevShadowY = this.shadowY;
        this.prevShadowZ = this.shadowZ;
        this.prevShadowX2 = this.shadowX2;
        this.prevShadowY2 = this.shadowY2;
        this.prevShadowZ2 = this.shadowZ2;
        this.prevYBodyRot = this.yBodyRot;
        this.prevYBodyRot2 = this.yBodyRot2;
        this.prevYRot = this.yRot;
        this.prevYRot2 = this.yRot2;
        this.yRot = (float)((double)this.yRot + (double)(livingEntity.getYRot() - this.yRot) * elasticity);
        this.yRot2 = (float)((double)this.yRot2 + (double)(this.yRot - this.yRot2) * elasticity);
        this.yBodyRot = (float)((double)this.yBodyRot + (double)(livingEntity.yBodyRot - this.yBodyRot) * elasticity);
        this.yBodyRot2 = (float)((double)this.yBodyRot2 + (double)(this.yBodyRot - this.yBodyRot2) * elasticity);
        this.xRot = (float)((double)this.xRot + (double)(livingEntity.getXRot() - this.xRot) * elasticity);
        this.xRot2 = (float)((double)this.xRot2 + (double)(this.xRot - this.xRot2) * elasticity);
        this.shadowX = (float)((double)this.shadowX + (livingEntity.getX() - (double)this.shadowX) * elasticity);
        this.shadowY = (float)((double)this.shadowY + (livingEntity.getY() - (double)this.shadowY) * elasticity);
        this.shadowZ = (float)((double)this.shadowZ + (livingEntity.getZ() - (double)this.shadowZ) * elasticity);
        this.shadowX2 = (float)((double)this.shadowX2 + (double)(this.shadowX - this.shadowX2) * elasticity);
        this.shadowY2 = (float)((double)this.shadowY2 + (double)(this.shadowY - this.shadowY2) * elasticity);
        this.shadowZ2 = (float)((double)this.shadowZ2 + (double)(this.shadowZ - this.shadowZ2) * elasticity);
        if (livingEntity.hasEffect(ModEffects.HYPER_SPARK)) {
            if (this.percentBoost >= 0.65f) {
                this.pushEntities(livingEntity);
            }
            this.tryAddBooster(livingEntity);
        }
    }

    protected void pushEntities(LivingEntity entity) {
        List list;
        if (!entity.level().isClientSide() && !(list = entity.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), entity.getBoundingBox().expandTowards((double)0.05f, 0.0, (double)0.05f), EntitySelector.pushableBy((Entity)entity))).isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                LivingEntity entity2 = (LivingEntity)list.get(l);
                if (entity == entity2 || entity.isAlliedTo((Entity)entity2)) continue;
                entity2.knockback(2.0 * (double)this.percentBoost, entity2.getX() - entity.getX(), entity2.getZ() - entity.getZ());
                entity2.hurt(entity.damageSources().mobAttack(entity), (float)Mth.floor((float)(8.0f * this.percentBoost)));
            }
        }
    }

    protected void removeBoost(LivingEntity entity) {
        AttributeInstance attributeinstance = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attributeinstance != null && attributeinstance.hasModifier(SPEED_MODIFIER_BOOST_UUID)) {
            attributeinstance.removeModifier(SPEED_MODIFIER_BOOST_UUID);
        }
    }

    protected void tryAddBooster(LivingEntity entity) {
        this.percentBoost = entity.isSprinting() && entity.getPose() == Pose.STANDING ? (this.percentBoost <= 1.0f ? (this.percentBoost += 0.01f) : 1.0f) : (this.percentBoost >= 0.0f ? (this.percentBoost -= 0.1f) : 0.0f);
        if (this.percentBoost > 0.0f && !entity.level().isClientSide) {
            AttributeInstance attributeinstance = entity.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeinstance == null) {
                return;
            }
            float f = 0.15f * this.percentBoost;
            attributeinstance.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_BOOST_UUID, (double)f, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public float getPercentBoost() {
        return this.percentBoost;
    }

    public ShadowCapability read(IAttachmentHolder iAttachmentHolder, CompoundTag compoundTag, HolderLookup.Provider provider) {
        return null;
    }

    @Nullable
    public CompoundTag write(ShadowCapability shadowCapability, HolderLookup.Provider provider) {
        return null;
    }
}

