/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod;

import bagu_chan.bagus_lib.util.JigsawHelper;
import baguchan.earthmobsmod.EarthMobsConfig;
import baguchan.earthmobsmod.client.ClientRegistrar;
import baguchan.earthmobsmod.message.MossMessage;
import baguchan.earthmobsmod.message.MudMessage;
import baguchan.earthmobsmod.registry.ModBiomeModifiers;
import baguchan.earthmobsmod.registry.ModBlocks;
import baguchan.earthmobsmod.registry.ModCapability;
import baguchan.earthmobsmod.registry.ModEffects;
import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModEntityDatas;
import baguchan.earthmobsmod.registry.ModFluidTypes;
import baguchan.earthmobsmod.registry.ModFluids;
import baguchan.earthmobsmod.registry.ModInstruments;
import baguchan.earthmobsmod.registry.ModInteractionInformations;
import baguchan.earthmobsmod.registry.ModItems;
import baguchan.earthmobsmod.registry.ModRecipes;
import baguchan.earthmobsmod.registry.ModSounds;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="earthmobsmod")
public class EarthMobsMod {
    public static final String MODID = "earthmobsmod";
    public static final Logger LOGGER = LogManager.getLogger((String)"earthmobsmod");

    public EarthMobsMod(ModContainer container, IEventBus modBus) {
        modBus.addListener(this::setup);
        modBus.addListener(this::setupPackets);
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        ModBlocks.BLOCKS.register(modBus);
        ModEntityDatas.ENTITIE_DATAS.register(modBus);
        ModEntities.ENTITIES.register(modBus);
        ModFluidTypes.FLUID_TYPES.register(modBus);
        ModFluids.FLUIDS.register(modBus);
        ModBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(modBus);
        ModEffects.MOB_EFFECTS.register(modBus);
        ModEffects.POTION.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModSounds.SOUND_EVENTS.register(modBus);
        ModCapability.ATTACHMENT_TYPES.register(modBus);
        ModInstruments.INSTRUMENTS.register(modBus);
        ModRecipes.RECIPE_SERIALIZERS.register(modBus);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EarthMobsConfig.COMMON_SPEC);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modBus.addListener(ClientRegistrar::setup);
        }
        NeoForge.EVENT_BUS.addListener(this::serverStart);
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playBidirectional(MossMessage.TYPE, MossMessage.STREAM_CODEC, (handler, payload) -> handler.handle((MossMessage)handler, payload));
        registrar.playBidirectional(MudMessage.TYPE, MudMessage.STREAM_CODEC, (handler, payload) -> handler.handle((MudMessage)handler, payload));
    }

    private void setup(FMLCommonSetupEvent event) {
        ModInteractionInformations.init();
        ModItems.composterInit();
        ModBlocks.initFire();
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BuiltInRegistries.BLOCK.getKey((Object)((Block)ModBlocks.BUTTERCUP.get())), ModBlocks.POTTED_BUTTERCUP);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BuiltInRegistries.BLOCK.getKey((Object)((Block)ModBlocks.PINK_DAISY.get())), ModBlocks.POTTED_PINK_DAISY);
    }

    private void serverStart(ServerAboutToStartEvent event) {
        JigsawHelper.registerJigsaw((MinecraftServer)event.getServer(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"trial_chambers/spawner/melee"), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"trial_chambers/connector/melee"), (int)1);
        JigsawHelper.registerJigsaw((MinecraftServer)event.getServer(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"trial_chambers/spawner/all"), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"trial_chambers/connector/ranged"), (int)1);
        JigsawHelper.registerJigsaw((MinecraftServer)event.getServer(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"trial_chambers/spawner/all"), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"trial_chambers/connector/melee"), (int)1);
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }
}

