/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod;

import baguchan.earthmobsmod.api.IMoss;
import baguchan.earthmobsmod.api.IMuddyPig;
import baguchan.earthmobsmod.block.CarvedMelonBlock;
import baguchan.earthmobsmod.capability.ShadowCapability;
import baguchan.earthmobsmod.entity.FurnaceGolem;
import baguchan.earthmobsmod.entity.ZombifiedPig;
import baguchan.earthmobsmod.entity.ZombifiedRabbit;
import baguchan.earthmobsmod.registry.ModBlocks;
import baguchan.earthmobsmod.registry.ModCapability;
import baguchan.earthmobsmod.registry.ModDamageSource;
import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.util.DyeUtil;
import com.mojang.serialization.DynamicOps;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="earthmobsmod")
public class CommonEvents {
    @SubscribeEvent
    public static void addSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Villager) {
            Villager abstractVillager = (Villager)entity;
            abstractVillager.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)abstractVillager, ZombifiedRabbit.class, 10.0f, (double)0.65f, (double)0.7f));
        }
        if ((entity = event.getEntity()) instanceof WanderingTrader) {
            WanderingTrader wanderingTraderEntity = (WanderingTrader)entity;
            wanderingTraderEntity.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)wanderingTraderEntity, ZombifiedRabbit.class, 10.0f, (double)0.65f, (double)0.7f));
        }
    }

    @SubscribeEvent
    public static void initSpawn(FinalizeSpawnEvent event) {
        Mob entity = event.getEntity();
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (entity instanceof IMoss) {
            IMoss moss = (IMoss)entity;
            if (serverLevelAccessor.getBiome(BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ())).is(Tags.Biomes.IS_SWAMP)) {
                moss.setMoss(true);
            }
        }
        if (entity instanceof IMuddyPig) {
            IMuddyPig muddy = (IMuddyPig)entity;
            if (serverLevelAccessor.getBiome(BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ())).is(Tags.Biomes.IS_SWAMP)) {
                muddy.setMuddy(true);
                byte b0 = muddy.getColorData();
                muddy.setColorData((byte)(b0 & 0xF0 | DyeUtil.getRandomColor(serverLevelAccessor.getRandom()).getId() & 0xF));
            }
        }
    }

    @SubscribeEvent
    public static void onToolUsing(BlockEvent.BlockToolModificationEvent event) {
        Direction direction;
        if (!event.isSimulated() && event.getItemAbility() == ItemAbilities.SHEARS_CARVE && event.getState().getBlock() == Blocks.MELON && (direction = event.getContext().getClickedFace()) != Direction.DOWN && direction != Direction.UP) {
            event.setFinalState((BlockState)ModBlocks.CARVED_MELON.get().defaultBlockState().setValue((Property)CarvedMelonBlock.FACING, (Comparable)direction));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch1;
        Direction direction;
        InteractionHand hand = event.getHand();
        ItemStack itemStack = event.getEntity().getItemInHand(hand);
        BlockPos pos = event.getPos();
        Level level = event.getEntity().level();
        if (itemStack.getItem() instanceof ShearsItem && event.getEntity().level().getBlockState(pos).getBlock() == Blocks.MELON && (direction = event.getHitVec().getDirection()) != Direction.DOWN && direction != Direction.UP) {
            itemStack.hurtAndBreak(1, (LivingEntity)event.getEntity(), LivingEntity.getSlotForHand((InteractionHand)hand));
            level.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, (BlockState)ModBlocks.CARVED_MELON.get().defaultBlockState().setValue((Property)CarvedMelonBlock.FACING, (Comparable)direction), 2);
            event.setUseItem(TriState.TRUE);
        }
        if (itemStack.is(Blocks.CARVED_PUMPKIN.asItem()) && (blockpattern$blockpatternmatch1 = CommonEvents.getOrCreateFurnaceGolemBase().find((LevelReader)level, pos.relative(event.getFace()))) != null) {
            FurnaceGolem irongolem = (FurnaceGolem)ModEntities.FURNACE_GOLEM.get().create(level);
            if (irongolem != null) {
                CommonEvents.spawnGolemInWorld(level, blockpattern$blockpatternmatch1, (Entity)irongolem, blockpattern$blockpatternmatch1.getBlock(1, 2, 0).getPos());
            }
            if (!event.getEntity().isCreative()) {
                itemStack.shrink(1);
            }
            event.getEntity().swing(hand);
            event.setCanceled(true);
        }
    }

    public static void clearPatternBlocks(Level p_249604_, BlockPattern.BlockPatternMatch p_251190_) {
        for (int i = 0; i < p_251190_.getWidth(); ++i) {
            for (int j = 0; j < p_251190_.getHeight(); ++j) {
                BlockInWorld blockinworld = p_251190_.getBlock(i, j, 0);
                p_249604_.setBlock(blockinworld.getPos(), Blocks.AIR.defaultBlockState(), 2);
                p_249604_.levelEvent(2001, blockinworld.getPos(), Block.getId((BlockState)blockinworld.getState()));
            }
        }
    }

    public static void updatePatternBlocks(Level p_248711_, BlockPattern.BlockPatternMatch p_251935_) {
        for (int i = 0; i < p_251935_.getWidth(); ++i) {
            for (int j = 0; j < p_251935_.getHeight(); ++j) {
                BlockInWorld blockinworld = p_251935_.getBlock(i, j, 0);
                p_248711_.blockUpdated(blockinworld.getPos(), Blocks.AIR);
            }
        }
    }

    private static BlockPattern getOrCreateFurnaceGolemBase() {
        return BlockPatternBuilder.start().aisle(new String[]{"   ", "#F#", " # "}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.IRON_BLOCK))).where('F', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.BLAST_FURNACE))).build();
    }

    @SubscribeEvent
    public static void onUpdate(EntityTickEvent.Pre event) {
        Entity entity;
        ShadowCapability shadowCapability = (ShadowCapability)event.getEntity().getData(ModCapability.SHADOW_ATTACH);
        if (shadowCapability != null && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            shadowCapability.tick(livingEntity);
        }
    }

    @SubscribeEvent
    public static void onLightning(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (event.getEntity().getType() != ModEntities.ZOMBIFIED_PIG.get()) {
                ZombifiedPig zombifiedpig = (ZombifiedPig)ModEntities.ZOMBIFIED_PIG.get().create(event.getEntity().level());
                zombifiedpig.moveTo(pig.getX(), pig.getY(), pig.getZ(), pig.getYRot(), pig.getXRot());
                zombifiedpig.setNoAi(pig.isNoAi());
                zombifiedpig.setBaby(pig.isBaby());
                if (pig.hasCustomName()) {
                    zombifiedpig.setCustomName(pig.getCustomName());
                    zombifiedpig.setCustomNameVisible(pig.isCustomNameVisible());
                }
                zombifiedpig.setPersistenceRequired();
                EventHooks.onLivingConvert((LivingEntity)pig, (LivingEntity)zombifiedpig);
                event.getEntity().level().addFreshEntity((Entity)zombifiedpig);
                pig.discard();
                event.setCanceled(true);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        Rabbit rabbit;
        LivingEntity living = event.getEntity();
        Level level = event.getEntity().level();
        if ((event.getSource().getDirectEntity() instanceof Zombie || event.getSource().getDirectEntity() instanceof ZombifiedRabbit) && living instanceof Rabbit) {
            rabbit = (Rabbit)living;
            if (!(living instanceof Enemy) && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ZombifiedRabbit zombierabbit = (ZombifiedRabbit)rabbit.convertTo(ModEntities.ZOMBIFIED_RABBIT.get(), false);
                if (zombierabbit != null) {
                    zombierabbit.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(zombierabbit.blockPosition()), MobSpawnType.CONVERSION, null);
                    zombierabbit.setVariant(rabbit.getVariant());
                    EventHooks.onLivingConvert((LivingEntity)rabbit, (LivingEntity)zombierabbit);
                    if (!rabbit.isSilent()) {
                        level.levelEvent(null, 1026, rabbit.blockPosition(), 0);
                    }
                }
            }
        }
        if (event.getSource().is(ModDamageSource.ZOMBIFIED)) {
            if (living instanceof Rabbit) {
                ZombifiedRabbit zombifiedRabbit;
                rabbit = (Rabbit)living;
                if (!(living instanceof Enemy) && (zombifiedRabbit = (ZombifiedRabbit)rabbit.convertTo(ModEntities.ZOMBIFIED_RABBIT.get(), false)) != null) {
                    zombifiedRabbit.setVariant(rabbit.getVariant());
                    if (!rabbit.isSilent()) {
                        level.levelEvent(null, 1026, rabbit.blockPosition(), 0);
                    }
                }
            }
            if (living instanceof Villager) {
                ZombieVillager zombieVillager;
                Villager villager = (Villager)living;
                if (!(living instanceof Enemy) && (zombieVillager = (ZombieVillager)villager.convertTo(EntityType.ZOMBIE_VILLAGER, false)) != null) {
                    zombieVillager.setVariant(villager.getVariant());
                    zombieVillager.setVillagerData(villager.getVillagerData());
                    zombieVillager.setVillagerXp(villager.getVillagerXp());
                    zombieVillager.setGossips((Tag)villager.getGossips().store((DynamicOps)NbtOps.INSTANCE));
                    zombieVillager.setTradeOffers(villager.getOffers().copy());
                    if (!villager.isSilent()) {
                        level.levelEvent(null, 1026, villager.blockPosition(), 0);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingIncomingDamageEvent event) {
        ShadowCapability shadowCapability = (ShadowCapability)event.getEntity().getData(ModCapability.SHADOW_ATTACH);
        if (shadowCapability != null && shadowCapability.getPercentBoost() >= 0.5f && !event.getSource().is(DamageTypeTags.BYPASSES_ARMOR) && !event.getSource().is(DamageTypeTags.IS_EXPLOSION) && !event.getSource().is(DamageTypeTags.IS_FIRE)) {
            event.setAmount(event.getAmount() * (1.0f - shadowCapability.getPercentBoost()));
            if (shadowCapability.getPercentBoost() > 0.9f) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingKnockback(LivingKnockBackEvent event) {
        ShadowCapability shadowCapability = (ShadowCapability)event.getEntity().getData(ModCapability.SHADOW_ATTACH);
        if (shadowCapability != null && shadowCapability.getPercentBoost() >= 0.5f) {
            event.setCanceled(true);
        }
    }

    private static void spawnGolemInWorld(Level level, BlockPattern.BlockPatternMatch blockPatternMatch, Entity summoner, BlockPos pos) {
        CommonEvents.clearPatternBlocks(level, blockPatternMatch);
        summoner.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.05, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity(summoner);
        for (ServerPlayer serverplayer : level.getEntitiesOfClass(ServerPlayer.class, summoner.getBoundingBox().inflate(5.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(serverplayer, summoner);
        }
        CommonEvents.updatePatternBlocks(level, blockPatternMatch);
    }
}

