/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.common.entity.spirit.SpiritItemEntity;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticles;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class SpiritLightSpecs {
    public static void spiritParticles(SpiritItemEntity spirit) {
        Vec3 direction = spirit.getDeltaMovement().add(0.0, (double)spirit.getYOffset(0.5f), 0.0).normalize();
        Vec3 motion = direction.scale((double)0.2f);
        Consumer<LodestoneWorldParticle> behavior = p -> {
            Vec3 spiritPosition = spirit.position().add(0.0, (double)spirit.getYOffset(0.5f), 0.0);
            Vec3 toSpirit = spiritPosition.subtract(p.getParticlePosition()).normalize();
            double length = p.getParticleSpeed().length();
            float delta = 0.3f + (float)p.getAge() / (float)p.getLifetime() * 0.7f;
            p.setParticleSpeed(p.getParticleSpeed().lerp(toSpirit.scale(length), (double)delta));
        };
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(spirit.level(), spirit.getOffsetPosition(), spirit.getSpiritType());
        lightSpecs.getBuilder().setMotion(motion).addTickActor(behavior);
        lightSpecs.getBloomBuilder().setMotion(motion).addTickActor(behavior);
        lightSpecs.spawnParticles();
    }

    public static void coolLookingShinyThing(Level level, Vec3 pos, SpiritLike spirit) {
        ParticleEffectSpawner centralLightSpecs = SpiritLightSpecs.spiritLightSpecs(level, pos, spirit, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC.get()));
        centralLightSpecs.getBuilder().multiplyLifetime(0.6f).modifyColorData(d -> d.multiplyCoefficient(0.5f)).modifyScaleData(d -> d.multiplyValue(6.0f)).modifyTransparencyData(d -> d.multiplyValue(3.0f));
        centralLightSpecs.getBloomBuilder().multiplyLifetime(0.6f).modifyColorData(d -> d.multiplyCoefficient(0.5f)).modifyScaleData(d -> d.multiplyValue(4.0f)).modifyTransparencyData(d -> d.multiplyValue(3.0f));
        centralLightSpecs.spawnParticles();
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, ColorParticleData colorData, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> modifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC.get()), colorData, distance, rotatingSpecs, modifier);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, ColorParticleData colorData, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> modifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, (Vec3 p) -> SpiritLightSpecs.spiritLightSpecs(level, p, colorData, options).act(modifier), distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, ColorParticleData colorData, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC.get()), colorData, distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, ColorParticleData colorData, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, (Vec3 p) -> SpiritLightSpecs.spiritLightSpecs(level, p, colorData, options), distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, SpiritLike spirit, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC.get()), spirit, distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, SpiritLike spirit, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, (Vec3 p) -> SpiritLightSpecs.spiritLightSpecs(level, p, spirit, options), distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, SpiritLike spirit, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> modifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, new WorldParticleOptions((ParticleType)MalumParticles.LIGHT_SPEC.get()), spirit, distance, rotatingSpecs, modifier);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, SpiritLike spirit, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> modifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, (Vec3 p) -> SpiritLightSpecs.spiritLightSpecs(level, p, spirit, options).act(modifier), distance, rotatingSpecs);
    }

    public static void rotatingLightSpecs(Level level, Vec3 pos, Function<Vec3, ParticleEffectSpawner> particleSpawner, float distance, int rotatingSpecs) {
        long gameTime = level.getGameTime();
        if (level.getGameTime() % 2L == 0L) {
            for (int i = 0; i < rotatingSpecs; ++i) {
                long offsetGameTime = gameTime + (long)i * 120L;
                double yOffset = Math.sin((float)(offsetGameTime % 360L) / 30.0f) * (double)0.1f;
                Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)pos.add(0.0, yOffset, 0.0), (float)distance, (float)i, (float)rotatingSpecs, (float)gameTime, (float)160.0f);
                ParticleEffectSpawner lightSpecs = particleSpawner.apply(offsetPosition);
                lightSpecs.getBuilder().setLifetimeModifier(2.0f).modifyScaleData(d -> d.multiplyValue(1.2f));
                lightSpecs.getBloomBuilder().setLifetimeModifier(1.4f).modifyScaleData(d -> d.multiplyValue(0.6f)).modifyTransparencyData(d -> d.multiplyValue(0.6f));
                lightSpecs.spawnParticles();
            }
        }
        ParticleEffectSpawner lightSpecs = particleSpawner.apply(pos);
        lightSpecs.getBuilder().multiplyLifetime(0.5f).modifyScaleData(d -> d.multiplyValue(1.7f)).modifyTransparencyData(d -> d.multiplyValue(0.5f));
        lightSpecs.getBloomBuilder().multiplyLifetime(0.5f).modifyScaleData(d -> d.multiplyValue(1.3f)).modifyTransparencyData(d -> d.multiplyValue(0.75f));
        lightSpecs.spawnParticles();
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, SpiritLike spirit) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, spirit, new WorldParticleOptions(MalumParticles.LIGHT_SPEC));
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, ColorParticleData colorData) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, colorData, new WorldParticleOptions(MalumParticles.LIGHT_SPEC));
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, SpiritLike spirit, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spirit));
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, ColorParticleData colorData, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData((ColorParticleDataWrapper)colorData));
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, WorldParticleBuilder::create);
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, WorldParticleOptions options, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier) {
        WorldParticleBuilder builder = builderSupplier.apply(options);
        WorldParticleBuilder bloomBuilder = builderSupplier.apply(new WorldParticleOptions(LodestoneParticleTypes.WISP_PARTICLE));
        return SpiritLightSpecs.spiritLightSpecs(level, pos, builder, bloomBuilder);
    }

    public static ParticleEffectSpawner spiritLightSpecs(Level level, Vec3 pos, WorldParticleBuilder builder, WorldParticleBuilder bloomBuilder) {
        RandomSource rand = level.getRandom();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)Mth.nextFloat((RandomSource)rand, (float)0.05f, (float)0.1f)).randomSpinOffset(rand).build();
        float friction = 0.95f;
        int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)10, (int)20);
        WorldParticleBuilder worldParticleBuilder = builder.setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.025f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.3f), (float)0.0f).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.8f, (float)0.0f).build()).multiplyFriction(friction).setSpinData((SpinParticleDataWrapper)spinData).setLifetime(lifetime).enableNoClip();
        WorldParticleBuilder bloomParticleBuilder = SpiritLightSpecs.spiritBloom(level, bloomBuilder, lifetime).setSpinData((SpinParticleDataWrapper)spinData).setFriction(friction);
        return new ParticleEffectSpawner(level, pos, worldParticleBuilder, bloomParticleBuilder);
    }

    public static WorldParticleBuilder spiritBloom(Level level, SpiritLike spirit, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, spirit, new WorldParticleOptions(LodestoneParticleTypes.WISP_PARTICLE), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, ColorParticleData colorData, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, colorData, new WorldParticleOptions(LodestoneParticleTypes.WISP_PARTICLE), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, SpiritLike spirit, WorldParticleOptions options, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, options, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spirit), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, ColorParticleData colorData, WorldParticleOptions options, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, options, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData((ColorParticleDataWrapper)colorData), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, WorldParticleOptions options, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, builderSupplier.apply(options), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(Level level, WorldParticleBuilder builder, int lifetime) {
        RandomSource rand = level.random;
        return builder.setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.04f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.08f, (float)0.14f), (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.35f, (float)0.0f).build()).setLifetime(lifetime).enableNoClip();
    }
}

