/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.obelisk.rite_pylon.ArcanaPylonBlockEntity;
import com.sammy.malum.common.block.curiosities.obelisk.runewood.RunewoodObeliskBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.ItemCrumbleParticleEffects;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class SpiritAltarParticleEffects {
    public static SpiritLike getCentralSpiritType(SpiritAltarBlockEntity altar) {
        LodestoneBlockEntityInventory spiritInventory = altar.spiritInventory;
        int spiritCount = spiritInventory.getFilledSlotCount();
        Item currentItem = spiritInventory.getStackInSlot(0).getItem();
        if (spiritCount > 1) {
            float duration = 30.0f * (float)spiritCount;
            float gameTime = (float)altar.getLevel().getGameTime() % duration / 30.0f;
            currentItem = spiritInventory.getStackInSlot(Mth.floor((float)gameTime)).getItem();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem;
    }

    public static void passiveSpiritAltarParticles(SpiritAltarBlockEntity altar) {
        SpiritLike activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        Level level = altar.getLevel();
        RandomSource random = level.random;
        Vec3 itemPos = altar.getItemPos();
        LodestoneBlockEntityInventory spiritInventory = altar.spiritInventory;
        SpiritInfusionRecipe recipe = altar.recipe;
        if (recipe != null) {
            for (IAltarAccelerator accelerator : altar.accelerators) {
                if (accelerator == null || !accelerator.canAccelerate()) continue;
                accelerator.addParticles(altar, activeSpiritType.getSpirit());
            }
            SpiritLightSpecs.rotatingLightSpecs(level, itemPos, activeSpiritType, 0.5f, 3, b -> b.multiplyLifetime(1.2f).modifyScaleData(d -> d.multiplyValue(1.2f)));
        }
        int spiritsRendered = 0;
        for (int i = 0; i < spiritInventory.slotCount; ++i) {
            ItemStack item = spiritInventory.getStackInSlot(i);
            Item item2 = item.getItem();
            if (!(item2 instanceof SpiritShardItem)) continue;
            SpiritShardItem shard = (SpiritShardItem)item2;
            Vec3 offset = altar.getSpiritItemOffset(spiritsRendered++, 0.0f);
            BlockPos blockPos = altar.getBlockPos();
            Vec3 spiritPosition = offset.add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
            SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, shard).spawnParticles();
            if (recipe == null) continue;
            Vec3 velocity = itemPos.subtract(spiritPosition).normalize().scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f));
            if (random.nextFloat() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, shard);
                sparkParticles.getBuilder().setMotion(velocity).modifyScaleData(d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().setMotion(velocity);
                sparkParticles.spawnParticles();
            }
            if (!(random.nextFloat() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, shard);
            lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.6f));
            lightSpecs.getBloomBuilder().setMotion(velocity);
            lightSpecs.spawnParticles();
        }
    }

    public static void eatItemParticles(Level level, SpiritAltarBlockEntity altar, IMalumSpecialItemAccessPoint holder, MalumNetworkedParticleEffectColorData colorData, ItemStack stack) {
        int i;
        SpiritLike activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        Vec3 altarTargetPos = altar.getItemPos();
        Vec3 holderTargetPos = holder.getItemPos();
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, holderTargetPos, activeSpiritType);
        }
        for (i = 0; i < 16; ++i) {
            int finalI = i;
            SpiritArcanaType cyclingSpiritType = colorData.getSpirit();
            Vec3 velocity = altarTargetPos.subtract(holderTargetPos).normalize().scale((double)0.025f);
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)holderTargetPos, (float)0.5f, (float)i, (float)16.0f, (float)gameTime, (float)160.0f);
            Consumer<LodestoneWorldParticle> behavior = p -> {
                if (level.getGameTime() > gameTime + (long)(finalI * 2) && level.getGameTime() < gameTime + (long)((finalI + 4) * 2)) {
                    p.setParticleSpeed(p.getParticleSpeed().add(velocity));
                }
            };
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, cyclingSpiritType);
            lightSpecs.getBuilder().addTickActor(behavior).multiplyLifetime(2.5f).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
            lightSpecs.getBloomBuilder().addTickActor(behavior).multiplyLifetime(2.0f).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.5f)));
            lightSpecs.spawnParticles();
            ParticleEffectSpawner crumbles = ItemCrumbleParticleEffects.spawnItemCrumbs(level, holderTargetPos, stack);
            crumbles.getBuilder().setLifeDelay(i).addTickActor(behavior);
            crumbles.spawnParticles();
            crumbles.getBuilder().setRandomOffset((double)0.2f);
            crumbles.spawnParticles();
        }
    }

    public static void craftItemParticles(Level level, SpiritAltarBlockEntity altar, MalumNetworkedParticleEffectColorData colorData) {
        ParticleEffectSpawner lightSpecs;
        int i;
        SpiritLike activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        BlockPos altarPos = altar.getBlockPos();
        Vec3 targetPos = altar.getCentralItemOffset().add((double)altarPos.getX(), (double)altarPos.getY(), (double)altarPos.getZ());
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, targetPos, activeSpiritType);
        }
        for (i = 0; i < 8; ++i) {
            SpiritArcanaType cyclingSpiritType = colorData.getSpirit();
            float xOffset = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)0.1f, (float)0.5f) * (float)(random.nextBoolean() ? -1 : 1);
            float yOffset = (float)i * 0.08f;
            float zOffset = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)0.1f, (float)0.5f) * (float)(random.nextBoolean() ? -1 : 1);
            Vec3 offsetPos = targetPos.add((double)xOffset, (double)yOffset, (double)zOffset);
            int lifeDelay = 5 + i * 3;
            lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPos, cyclingSpiritType, new WorldParticleOptions(MalumParticles.SHINE));
            lightSpecs.getBuilder().modifyTransparencyData(d -> d.multiplyValue(1.25f)).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).randomSpinOffset(random).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.3f).build()).multiplyLifetime(1.25f).setLifeDelay(lifeDelay).disableNoClip();
            lightSpecs.getBloomBuilder().modifyScaleData(d -> d.multiplyValue(3.0f)).modifyTransparencyData(d -> d.multiplyValue(1.25f)).multiplyLifetime(0.85f).setLifeDelay(lifeDelay).disableNoClip();
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 12; ++i) {
            int lifeDelay = i / 4;
            SpiritArcanaType cyclingSpiritType = colorData.getSpirit();
            float xVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yVelocity = RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.5f);
            float zVelocity = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.0f);
            if (random.nextFloat() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, targetPos, cyclingSpiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(1.5f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyScaleData(d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(1.5f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyTransparencyData(d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.nextFloat() < 0.85f)) continue;
            lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, targetPos, cyclingSpiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravity(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyScaleData(d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(1.5f).setGravity(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyTransparencyData(d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 8; ++i) {
            int finalI = i;
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)targetPos, (float)0.6f, (float)i, (float)8.0f, (float)gameTime, (float)160.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (level.getGameTime() > gameTime + (long)(finalI * 4) && level.getGameTime() < gameTime + (long)((finalI + 4) * 4)) {
                    p.setParticleSpeed(p.getParticleSpeed().add(0.0, (double)0.015f, 0.0));
                }
            });
            int lifetime = RandomHelper.randomBetween((RandomSource)random, (int)10, (int)20) + finalI * 2;
            ParticleEffectSpawner lightSpecs2 = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, activeSpiritType);
            lightSpecs2.getBuilder().act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifetime(lifetime);
            lightSpecs2.getBloomBuilder().act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(1.6f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifetime(lifetime);
            lightSpecs2.spawnParticles();
        }
    }

    public static void runewoodObeliskParticles(RunewoodObeliskBlockEntity obelisk, SpiritAltarBlockEntity altar, SpiritArcanaType spiritType) {
        Level level = obelisk.getLevel();
        BlockPos obeliskPos = obelisk.getBlockPos();
        Vec3 startPos = obelisk.getParticleOffset().add((double)obeliskPos.getX(), (double)obeliskPos.getY(), (double)obeliskPos.getZ());
        SpiritLightSpecs.spiritLightSpecs(level, startPos, spiritType).spawnParticles();
        if (level.getGameTime() % 2L == 0L) {
            RandomSource random = level.random;
            long gameTime = level.getGameTime();
            BlockPos altarPos = altar.getBlockPos();
            Vec3 targetPos = altar.getCentralItemOffset().add((double)altarPos.getX(), (double)altarPos.getY(), (double)altarPos.getZ());
            Vec3 direction = targetPos.subtract(startPos).normalize();
            Vec3 velocity = direction.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.01f, (float)0.02f));
            double yOffset = Math.sin((float)gameTime * 0.2f % 6.28f) * (double)0.1f;
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)startPos.add(0.0, yOffset, 0.0), (float)0.45f, (float)0.0f, (float)1.0f, (float)gameTime, (float)30.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (gameTime % 6L == 0L) {
                    p.setParticleSpeed(p.getParticleSpeed().scale((double)1.05f));
                }
            });
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spiritType);
            lightSpecs.getBuilder().act(behavior).setMotion(velocity).multiplyLifetime(2.0f).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
            lightSpecs.getBloomBuilder().act(behavior).setMotion(velocity).multiplyLifetime(1.5f).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.5f)));
            lightSpecs.spawnParticles();
        }
    }

    public static void arcanaPylonParticles(ArcanaPylonBlockEntity arcanaPylon, SpiritAltarBlockEntity altar, SpiritArcanaType spiritType) {
        Level level = arcanaPylon.getLevel();
        Vec3 startPos = arcanaPylon.getItemPos();
        SpiritLightSpecs.spiritLightSpecs(level, startPos, spiritType).spawnParticles();
        if (level.getGameTime() % 2L == 0L) {
            RandomSource random = level.random;
            long gameTime = level.getGameTime();
            BlockPos altarPos = altar.getBlockPos();
            Vec3 targetPos = altar.getCentralItemOffset().add((double)altarPos.getX(), (double)altarPos.getY(), (double)altarPos.getZ());
            Vec3 direction = targetPos.subtract(startPos).normalize();
            Vec3 velocity = direction.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.025f, (float)0.04f));
            double yOffset = Math.sin((float)gameTime * 0.4f % 6.28f) * (double)0.1f;
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)startPos.add(0.0, yOffset, 0.0), (float)0.45f, (float)0.0f, (float)1.0f, (float)gameTime, (float)40.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (gameTime % 6L == 0L) {
                    p.setParticleSpeed(p.getParticleSpeed().scale((double)1.1f));
                }
            });
            ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, offsetPosition, spiritType);
            sparks.getBuilder().act(behavior).setMotion(velocity).multiplyLifetime(3.0f).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
            sparks.getBloomBuilder().act(behavior).setMotion(velocity).multiplyLifetime(2.5f).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.5f)));
            sparks.spawnParticles();
        }
    }
}

