/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.registry.common.magic.rite;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.registry.rite.DeferredRiteTypes;
import com.sammy.malum.core.systems.registry.rite.RiteHolder;
import com.sammy.malum.core.systems.rite.SpiritRiteType;
import com.sammy.malum.core.systems.rite.SpiritRiteTypeBuilder;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.registry.common.magic.rite.MalumSpiritRiteEffectTypes;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MalumSpiritRiteTypes {
    public static ResourceKey<Registry<SpiritRiteType>> RITE_KEY = ResourceKey.createRegistryKey((ResourceLocation)MalumMod.malumPath("spirit_rite_types"));
    public static final DeferredRiteTypes RITE_TYPES = DeferredRiteTypes.create("malum");
    public static final Registry<SpiritRiteType> RITE_REGISTRY = RITE_TYPES.makeRegistry(builder -> builder.defaultKey(MalumMod.malumPath("undirected_rite")).sync(true));
    public static final RiteHolder<SpiritRiteType> UNDIRECTED_RITE = RITE_TYPES.register("undirected_rite", () -> SpiritRiteTypeBuilder.specialTotemRite(MalumSpiritTypes.ARCANE_SPIRIT).build(MalumSpiritRiteEffectTypes.UNDIRECTED_RITE_EFFECT));
    public static final RiteHolder<SpiritRiteType> UNCHAINED_RITE = RITE_TYPES.register("unchained_rite", () -> SpiritRiteTypeBuilder.specialTotemRite(MalumSpiritTypes.ARCANE_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.UNCHAINED_RITE_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_HEALING = RITE_TYPES.register("rite_of_healing", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.SACRED_SPIRIT).build(MalumSpiritRiteEffectTypes.HEALING_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_NOURISHMENT = RITE_TYPES.register("rite_of_nourishment", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.SACRED_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.NOURISHMENT_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_NURTURING = RITE_TYPES.register("rite_of_nurturing", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.SACRED_SPIRIT).build(MalumSpiritRiteEffectTypes.NURTURING_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_LUST = RITE_TYPES.register("rite_of_lust", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.SACRED_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.LUST_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_HARMING = RITE_TYPES.register("rite_of_harming", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.WICKED_SPIRIT).build(MalumSpiritRiteEffectTypes.HARMING_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_EMPOWERMENT = RITE_TYPES.register("rite_of_empowerment", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.WICKED_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.EMPOWERMENT_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_CULLING = RITE_TYPES.register("rite_of_culling", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.WICKED_SPIRIT).build(MalumSpiritRiteEffectTypes.CULLING_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_RAISING = RITE_TYPES.register("rite_of_rending", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.WICKED_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.RAISING_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_THE_HOWLING_GALE = RITE_TYPES.register("rite_of_the_howling_gale", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.AERIAL_SPIRIT).build(MalumSpiritRiteEffectTypes.APPLY_HOWLING_GALE_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_THE_SKY_TETHER = RITE_TYPES.register("rite_of_the_sky_tether", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.AERIAL_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.APPLY_SKY_TETHER_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_GRAVITY = RITE_TYPES.register("rite_of_gravity", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.AERIAL_SPIRIT).build(MalumSpiritRiteEffectTypes.BLOCK_GRAVITY_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_ASCENSION = RITE_TYPES.register("rite_of_ascension", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.AERIAL_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.BLOCK_ASCENSION_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_THE_FLOWING_GRASP = RITE_TYPES.register("rite_of_the_flowing_grasp", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.AQUEOUS_SPIRIT).build(MalumSpiritRiteEffectTypes.APPLY_FLOWING_GRASP_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_THE_GOOD_TIDES = RITE_TYPES.register("rite_of_the_good_tides", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.AQUEOUS_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.THE_GOOD_TIDES_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_SOAKING = RITE_TYPES.register("rite_of_soaking", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.AQUEOUS_SPIRIT).build(MalumSpiritRiteEffectTypes.SOAKING_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_SAPPING = RITE_TYPES.register("rite_of_sapping", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.AQUEOUS_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.SAPPING_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_THE_STONE_WARD = RITE_TYPES.register("rite_of_the_stone_ward", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.EARTHEN_SPIRIT).build(MalumSpiritRiteEffectTypes.APPLY_STONE_WARD_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_THE_OAKEN_MIGHT = RITE_TYPES.register("rite_of_the_oaken_might", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.EARTHEN_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.APPLY_OAKEN_MIGHT_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_CREATION = RITE_TYPES.register("rite_of_creation", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.EARTHEN_SPIRIT).build(MalumSpiritRiteEffectTypes.CREATION_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_DESTRUCTION = RITE_TYPES.register("rite_of_destruction", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.EARTHEN_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.DESTRUCTION_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_THE_BURNING_FERVOR = RITE_TYPES.register("rite_of_the_burning_fervor", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.INFERNAL_SPIRIT).build(MalumSpiritRiteEffectTypes.APPLY_BURNING_FERVOR_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_THE_FIERY_EMBRACE = RITE_TYPES.register("rite_of_the_fiery_embrace", () -> SpiritRiteTypeBuilder.minorTotemRite(MalumSpiritTypes.INFERNAL_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.APPLY_FIERY_EMBRACE_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_SMELTING = RITE_TYPES.register("rite_of_smelting", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.INFERNAL_SPIRIT).build(MalumSpiritRiteEffectTypes.SMELTING_EFFECT));
    public static final RiteHolder<SpiritRiteType> RITE_OF_QUICKENING = RITE_TYPES.register("rite_of_quickening", () -> SpiritRiteTypeBuilder.majorTotemRite(MalumSpiritTypes.INFERNAL_SPIRIT).setCorrupted().build(MalumSpiritRiteEffectTypes.QUICKENING_EFFECT));

    public static SpiritRiteType getRite(ServerLevel level, TotemBaseBlockEntity totemBase) {
        List<SpiritRiteType> rites = RITE_TYPES.getEntries().stream().map(DeferredHolder::get).toList();
        for (SpiritRiteType rite : rites) {
            if (!rite.matches(level, totemBase)) continue;
            return rite;
        }
        return null;
    }
}

