/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.worldgen;

import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.worldgen.MalumFeatures;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class BiomeModificationDatagen {
    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        BiomeModificationDatagen.register(context, "soulstone_ore", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.ORE_SOULSTONE), MalumTags.BiomeTags.HAS_SOULSTONE, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModificationDatagen.register(context, "brilliant_ore", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.ORE_BRILLIANT), MalumTags.BiomeTags.HAS_BRILLIANT, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModificationDatagen.register(context, "natural_quartz_ore", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.ORE_NATURAL_QUARTZ), MalumTags.BiomeTags.HAS_QUARTZ, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModificationDatagen.register(context, "cthonic_gold_ore", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.ORE_CTHONIC_GOLD), MalumTags.BiomeTags.HAS_CTHONIC, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModificationDatagen.register(context, "blazing_quartz_ore", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.ORE_BLAZING_QUARTZ), MalumTags.BiomeTags.HAS_BLAZING_QUARTZ, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModificationDatagen.register(context, "runewood_tree", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.RUNEWOOD_TREE), MalumTags.BiomeTags.HAS_RUNEWOOD, GenerationStep.Decoration.VEGETAL_DECORATION));
        BiomeModificationDatagen.register(context, "rare_runewood_tree", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.RARE_RUNEWOOD_TREE), MalumTags.BiomeTags.HAS_RARE_RUNEWOOD, GenerationStep.Decoration.VEGETAL_DECORATION));
        BiomeModificationDatagen.register(context, "azure_runewood_tree", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.AZURE_RUNEWOOD_TREE), MalumTags.BiomeTags.HAS_AZURE_RUNEWOOD, GenerationStep.Decoration.VEGETAL_DECORATION));
        BiomeModificationDatagen.register(context, "rare_azure_runewood_tree", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.RARE_AZURE_RUNEWOOD_TREE), MalumTags.BiomeTags.HAS_RARE_AZURE_RUNEWOOD, GenerationStep.Decoration.VEGETAL_DECORATION));
        BiomeModificationDatagen.register(context, "quartz_geode", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.QUARTZ_GEODE_FEATURE), MalumTags.BiomeTags.HAS_QUARTZ, GenerationStep.Decoration.UNDERGROUND_DECORATION));
        BiomeModificationDatagen.register(context, "deepslate_quartz_geode", () -> BiomeModificationDatagen.addFeatureModifier(context, BiomeModificationDatagen.getPlacedHolderSet(context, MalumFeatures.PlacedFeatures.DEEPSLATE_QUARTZ_GEODE_FEATURE), MalumTags.BiomeTags.HAS_QUARTZ, GenerationStep.Decoration.UNDERGROUND_DECORATION));
    }

    public static HolderSet<PlacedFeature> getPlacedHolderSet(BootstrapContext<?> context, ResourceKey<PlacedFeature> ... placedFeatures) {
        ArrayList<Holder.Reference> holders = new ArrayList<Holder.Reference>();
        for (ResourceKey<PlacedFeature> feature : placedFeatures) {
            holders.add(context.lookup(Registries.PLACED_FEATURE).getOrThrow(feature));
        }
        return HolderSet.direct(holders);
    }

    private static BiomeModifiers.AddFeaturesBiomeModifier addFeatureModifier(BootstrapContext<BiomeModifier> context, HolderSet<PlacedFeature> placedSet, TagKey<Biome> biomeTag, GenerationStep.Decoration decoration) {
        return new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.lookup(Registries.BIOME).getOrThrow(biomeTag), placedSet, decoration);
    }

    private static void register(BootstrapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)MalumMod.malumPath(name)), (Object)modifier.get());
    }
}

