/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.google.common.collect.ImmutableSet;
import com.sammy.malum.common.block.curiosities.mana_mote.ManaMoteBlock;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class SpiritTypeProperty
extends Property<String> {
    private final ImmutableSet<String> values;
    public static final SpiritTypeProperty SPIRIT_TYPE = new SpiritTypeProperty("spirit", MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT);

    public static SpiritHolder<SpiritArcanaType> getSpiritType(BlockState state) {
        if (state.hasProperty((Property)SPIRIT_TYPE)) {
            return SpiritHolder.getSpiritType((String)((Object)state.getValue((Property)ManaMoteBlock.SPIRIT_TYPE)));
        }
        throw new IllegalArgumentException("BlockState does not have a spirit type property.");
    }

    public static BlockState setSpiritType(BlockState state, SpiritLike spiritType) {
        if (state.hasProperty((Property)SPIRIT_TYPE)) {
            return (BlockState)state.setValue((Property)ManaMoteBlock.SPIRIT_TYPE, (Comparable)((Object)spiritType.getName()));
        }
        throw new IllegalArgumentException("BlockState does not have a spirit type property.");
    }

    @SafeVarargs
    public SpiritTypeProperty(String name, SpiritHolder<SpiritArcanaType> ... validSpirits) {
        this(name, List.of(validSpirits));
    }

    public SpiritTypeProperty(String name, Collection<SpiritHolder<SpiritArcanaType>> validSpirits) {
        super(name, String.class);
        this.values = ImmutableSet.copyOf((Collection)validSpirits.stream().map(DeferredHolder::getId).map(ResourceLocation::getPath).collect(Collectors.toList()));
    }

    @NotNull
    public Collection<String> getPossibleValues() {
        return this.values;
    }

    @NotNull
    public Optional<String> getValue(@NotNull String value) {
        return this.values.stream().filter(v -> v.equals(value)).findAny();
    }

    @NotNull
    public String getName(@NotNull String value) {
        return value;
    }
}

