/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.registry;

import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class SpiritHolder<T extends SpiritArcanaType>
extends DeferredHolder<SpiritArcanaType, T>
implements SpiritLike {
    protected SpiritHolder(ResourceKey<SpiritArcanaType> key) {
        super(key);
    }

    public static SpiritHolder<SpiritArcanaType> getSpiritType(CompoundTag pTag) {
        return SpiritHolder.getSpiritType(pTag.getString("spirit"));
    }

    public static SpiritHolder<SpiritArcanaType> getSpiritType(String spirit) {
        return SpiritHolder.getSpiritType(ResourceLocation.parse((String)spirit));
    }

    public static SpiritHolder<SpiritArcanaType> getSpiritType(ResourceLocation spirit) {
        if (spirit.getNamespace().equals("minecraft")) {
            spirit = MalumMod.malumPath(spirit.getPath());
        }
        return new SpiritHolder<SpiritArcanaType>((ResourceKey<SpiritArcanaType>)ResourceKey.create(MalumSpiritTypes.SPIRIT_TYPES_KEY, (ResourceLocation)spirit));
    }

    public boolean is(SpiritLike spirit) {
        return this.getSpirit().equals(spirit.getSpirit());
    }

    @Override
    @NotNull
    public SpiritArcanaType getSpirit() {
        return (SpiritArcanaType)this.get();
    }

    public SpiritArcanaType orElse(SpiritArcanaType fallback) {
        return this.isBound() ? (SpiritArcanaType)this.value() : fallback;
    }
}

