/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.artifice;

import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeInfluenceData;
import com.sammy.malum.core.systems.artifice.ArtificeModifierSourceInstance;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;

public interface IArtificeAcceptor {
    public ArtificeAttributeData getAttributes();

    public void setAttributes(ArtificeAttributeData var1);

    default public int getLookupRadius() {
        return 4;
    }

    public SpiritArcanaType getActiveSpiritType();

    public Vec3 getVisualAccelerationPoint();

    public void applyAugments(Consumer<ItemStack> var1);

    default public void recalibrateAccelerators(@Nonnull Level level) {
        BlockPos pos = this.asBlockEntity().getBlockPos();
        this.invalidateModifiers(level);
        ArtificeAttributeData attributes = new ArtificeAttributeData(this);
        ArtificeInfluenceData influence = ArtificeInfluenceData.createFreshData(this.getLookupRadius(), level, pos, attributes);
        this.setAttributes(attributes.applyModifierInfluence(influence));
        this.bindModifiers(level);
        BlockStateHelper.updateState((Level)level, (BlockPos)pos);
    }

    default public void invalidateModifiers(@Nonnull Level level) {
        this.getAttributes().getInfluenceData(level).ifPresent(d -> {
            for (ArtificeModifierSourceInstance modifier : d.modifiers()) {
                modifier.invalidate();
            }
        });
    }

    default public void bindModifiers(@Nonnull Level level) {
        this.getAttributes().getInfluenceData(level).ifPresent(d -> {
            for (ArtificeModifierSourceInstance modifier : d.modifiers()) {
                modifier.bind(this);
            }
        });
    }

    default public BlockEntity asBlockEntity() {
        return (BlockEntity)this;
    }
}

