/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

public class SpiritDataReloadListener
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceLocation, EntitySpiritDropData> SPIRIT_DATA = new HashMap<ResourceLocation, EntitySpiritDropData>();
    public static final Set<ResourceLocation> HAS_NO_DATA = new HashSet<ResourceLocation>();
    public static final EntitySpiritDropData DEFAULT_MONSTER_SPIRIT_DATA = EntitySpiritDropData.builder(MalumSpiritTypes.WICKED_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_CREATURE_SPIRIT_DATA = EntitySpiritDropData.builder(MalumSpiritTypes.SACRED_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_AMBIENT_SPIRIT_DATA = EntitySpiritDropData.builder(MalumSpiritTypes.AERIAL_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_WATER_CREATURE_SPIRIT_DATA = EntitySpiritDropData.builder(MalumSpiritTypes.AQUEOUS_SPIRIT).withSpirit(MalumSpiritTypes.SACRED_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_WATER_AMBIENT_SPIRIT_DATA = EntitySpiritDropData.builder(MalumSpiritTypes.AQUEOUS_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_UNDERGROUND_WATER_CREATURE_SPIRIT_DATA = EntitySpiritDropData.builder(MalumSpiritTypes.AQUEOUS_SPIRIT).withSpirit(MalumSpiritTypes.EARTHEN_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_AXOLOTL_SPIRIT_DATA = EntitySpiritDropData.builder(MalumSpiritTypes.AQUEOUS_SPIRIT, 2).withSpirit(MalumSpiritTypes.SACRED_SPIRIT).build();
    public static final EntitySpiritDropData DEFAULT_BOSS_SPIRIT_DATA = EntitySpiritDropData.builder(MalumSpiritTypes.ELDRITCH_SPIRIT, 4).build();
    private static final Gson GSON = new GsonBuilder().create();

    public SpiritDataReloadListener() {
        super(GSON, "spirit_data/entity");
    }

    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SpiritDataReloadListener());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        SPIRIT_DATA.clear();
        HAS_NO_DATA.clear();
        for (JsonElement entry : objectIn.values()) {
            JsonObject object = entry.getAsJsonObject();
            String name = object.getAsJsonPrimitive("registry_name").getAsString();
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)name);
            if (resourceLocation == null || !BuiltInRegistries.ENTITY_TYPE.containsKey(resourceLocation)) continue;
            if (object.has("no_spirits") && object.get("no_spirits").getAsBoolean()) {
                MalumMod.LOGGER.info("Removed spirit drops for entity with registry name: {}", (Object)name);
                SPIRIT_DATA.remove(resourceLocation);
                HAS_NO_DATA.add(resourceLocation);
                continue;
            }
            String primaryType = object.getAsJsonPrimitive("primary_type").getAsString();
            if (primaryType.equals("none")) continue;
            SpiritHolder<SpiritArcanaType> holder = SpiritHolder.getSpiritType(primaryType);
            if (!holder.isBound()) {
                MalumMod.LOGGER.info("No such spirit exists, this is a datapack error: {}", (Object)primaryType);
                continue;
            }
            MalumMod.LOGGER.info("Added spirit drops for entity with registry name: {}", (Object)name);
            JsonArray array = object.getAsJsonArray("spirits");
            SPIRIT_DATA.put(resourceLocation, new EntitySpiritDropData(holder, SpiritDataReloadListener.getSpiritDrops(array), SpiritDataReloadListener.getItemAsSoul(object)));
            HAS_NO_DATA.remove(resourceLocation);
        }
    }

    private static List<SpiritIngredient> getSpiritDrops(JsonArray array) {
        ArrayList<SpiritIngredient> spiritData = new ArrayList<SpiritIngredient>();
        for (JsonElement spiritElement : array) {
            JsonObject spiritObject = spiritElement.getAsJsonObject();
            String spiritName = spiritObject.getAsJsonPrimitive("spirit").getAsString();
            int count = spiritObject.has("count") ? spiritObject.getAsJsonPrimitive("count").getAsInt() : 1;
            spiritData.add(new SpiritIngredient((Holder<SpiritArcanaType>)SpiritHolder.getSpiritType(spiritName), count));
        }
        return spiritData;
    }

    private static Ingredient getItemAsSoul(JsonObject object) {
        return object.has("spirit_item") ? (Ingredient)Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)object.get("spirit_item")).map(Pair::getFirst).result().orElse(null) : null;
    }
}

