/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.blight;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.common.worldgen.WorldgenHelper;
import com.sammy.malum.common.worldgen.blight.ScarstoneFeature;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.blight.BlightParticleEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.worldgen.LodestoneWorldgenBuilder;
import team.lodestar.lodestone.systems.worldgen.LodestoneWorldgenBuilderEntry;
import team.lodestar.lodestone.systems.worldgen.LodestoneWorldgenBuilderLayer;

public class BlightFeature
extends Feature<NoneFeatureConfiguration> {
    private static final PerlinSimplexNoise COVERING_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(1234L)), (List)ImmutableList.of((Object)0));

    public BlightFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        BlightFeature.generateBlight(level, pos, 8).place(level);
        return true;
    }

    public static void createBlightVFX(ServerLevel level, BlockPos sourcePos, LodestoneWorldgenBuilder blight) {
        MalumParticleEffectTypes.BLIGHT_PROPAGATION.createEffect(sourcePos).customData(new BlightParticleEffect.BlightEffectData(blight.getAffectedArea(0))).spawn(level);
        MalumParticleEffectTypes.BLIGHT_PLANT_GROWTH.createEffect(sourcePos).customData(new BlightParticleEffect.BlightEffectData(blight.getAffectedArea(1))).spawn(level);
    }

    public static void createScarstoneVFX(ServerLevel level, BlockPos sourcePos, LodestoneWorldgenBuilder scarstone) {
        MalumParticleEffectTypes.SCARSTONE_FORMS.createEffect(sourcePos).color(MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT).customData(new BlightParticleEffect.BlightEffectData(scarstone.getAffectedArea(0))).spawn(level);
        MalumParticleEffectTypes.STRANGE_CRYSTAL_FORMS.createEffect(sourcePos).color(MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT).customData(new BlightParticleEffect.BlightEffectData(scarstone.getAffectedArea(1))).spawn(level);
    }

    public static LodestoneWorldgenBuilder generateBlight(WorldGenLevel level, BlockPos pos, boolean allowScarstone, int radius) {
        RandomSource random = level.getRandom();
        LodestoneWorldgenBuilder builder = LodestoneWorldgenBuilder.create();
        if (allowScarstone && random.nextFloat() < 0.1f) {
            int offset = (int)((float)radius * 0.8f);
            int xOffset = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CIRC_OUT, (int)(offset / 2), (int)(offset * 2)) * (random.nextBoolean() ? 1 : -1);
            int zOffset = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CIRC_OUT, (int)(offset / 2), (int)(offset * 2)) * (random.nextBoolean() ? 1 : -1);
            BlockPos scarstonePos = pos.offset(xOffset, 0, zOffset);
            LodestoneWorldgenBuilder extraBlight = BlightFeature.generateBlight(level, scarstonePos, radius);
            LodestoneWorldgenBuilder scarstone = ScarstoneFeature.generateScarstone(level, scarstonePos, (int)((float)radius * 0.7f));
            builder.merge(extraBlight).merge(scarstone);
            if (level instanceof ServerLevel) {
                ServerLevel realLevel = (ServerLevel)level;
                BlightFeature.createBlightVFX(realLevel, pos, extraBlight);
                BlightFeature.createScarstoneVFX(realLevel, scarstonePos, scarstone);
                level.playSound(null, scarstonePos, (SoundEvent)MalumSoundEvents.SCARSTONE_PROPAGATION.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            }
        }
        LodestoneWorldgenBuilder blight = BlightFeature.generateBlight(level, pos, radius);
        builder.merge(blight);
        if (level instanceof ServerLevel) {
            ServerLevel realLevel = (ServerLevel)level;
            BlightFeature.createBlightVFX(realLevel, pos, blight);
            level.playSound(null, pos, (SoundEvent)MalumSoundEvents.BLIGHT_PROPAGATION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return builder;
    }

    private static LodestoneWorldgenBuilder generateBlight(WorldGenLevel level, BlockPos pos, int radius) {
        List<BlockPos> coveringArea;
        BlockPos above;
        RandomSource random = level.getRandom();
        LodestoneWorldgenBuilder builder = LodestoneWorldgenBuilder.create().addAdditionalPlacement(BlightFeature::cleanupFoliage);
        LodestoneWorldgenBuilderLayer blightLayer = builder.createLayer();
        LodestoneWorldgenBuilderLayer floraLayer = builder.createLayer();
        LodestoneWorldgenBuilderLayer coveringLayer = builder.createLayer();
        List<BlockPos> blightedArea = BlightFeature.fetchCoveringPositions((ServerLevelAccessor)level, pos, radius);
        for (BlockPos blockPos : blightedArea) {
            BlockState state = level.getBlockState(blockPos);
            if (!state.is(MalumTags.BlockTags.BLIGHT_REPLACEABLE)) continue;
            blightLayer.add(blockPos, (Block)MalumBlocks.BLIGHTED_EARTH.get());
        }
        if (!blightedArea.isEmpty()) {
            List<BlockPos> floraPositions = WorldgenHelper.shuffle(blightedArea, random);
            int floraCount = Math.min(random.nextInt(1, radius * 4 + 1), floraPositions.size() - 1);
            boolean hasSoulwood = false;
            for (BlockPos blockPos : floraPositions) {
                Block block;
                above = blockPos.above();
                BlockState state = level.getBlockState(above);
                if (!state.getFluidState().isEmpty() || !state.canBeReplaced() || state.is(MalumTags.BlockTags.BLIGHTED_PLANTS)) continue;
                if (radius > 3 && !hasSoulwood && random.nextFloat() < 0.1f) {
                    block = (Block)MalumBlocks.SOULWOOD_SAPLING.get();
                    hasSoulwood = true;
                } else {
                    block = random.nextFloat() < 0.4f ? (random.nextFloat() < 0.2f ? (Block)MalumBlocks.BLIGHTPEARL.get() : (Block)MalumBlocks.BLIGHTROOT.get()) : (Block)MalumBlocks.BLIGHTED_GROWTH.get();
                }
                floraLayer.add(above, block);
                if (--floraCount != 0) continue;
                break;
            }
        }
        if (!(coveringArea = WorldgenHelper.shuffle(BlightFeature.fetchCoveringPositions((ServerLevelAccessor)level, pos, radius + 3), random)).isEmpty()) {
            int coveringCount = Math.min(random.nextInt(1, 8 + radius * 8 + 1), coveringArea.size() - 1);
            for (BlockPos blockPos : coveringArea) {
                BlockState state = level.getBlockState(blockPos);
                if (!state.is(MalumTags.BlockTags.BLIGHT_REPLACEABLE) || blightLayer.containsKey(blockPos)) continue;
                above = blockPos.above();
                boolean isWaterLogged = level.getBlockState(above).getFluidState().is((Fluid)Fluids.WATER);
                BlockState covering = (BlockState)((BlockState)((Block)MalumBlocks.BLIGHT.get()).defaultBlockState().setValue((Property)MultifaceBlock.getFaceProperty((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
                coveringLayer.add(above, covering);
                if (--coveringCount != 0) continue;
                break;
            }
        }
        return builder;
    }

    public static void cleanupFoliage(WorldGenLevel level, LodestoneWorldgenBuilderEntry entry) {
        BlockPos.MutableBlockPos mutable = entry.position().mutable();
        for (int i = 0; i < 3; ++i) {
            mutable.move(Direction.UP);
            BlockState aboveState = level.getBlockState((BlockPos)mutable);
            if (!aboveState.getFluidState().isEmpty() || !aboveState.is(MalumTags.BlockTags.BLIGHT_REMOVABLE)) continue;
            level.setBlock((BlockPos)mutable, Blocks.AIR.defaultBlockState(), 19);
            if (!(level instanceof Level)) continue;
            Level realLevel = (Level)level;
            BlockStateHelper.updateState((Level)realLevel, (BlockPos)mutable);
        }
    }

    public static List<BlockPos> fetchCoveringPositions(ServerLevelAccessor level, BlockPos center, int radius) {
        return BlightFeature.fetchCoveringPositions(level, center, radius, BlightFeature::canBeRemoved).stream().filter(p -> {
            BlockState above = level.getBlockState(p.above());
            return above.canBeReplaced() || above.is(MalumTags.BlockTags.BLIGHT_REMOVABLE);
        }).collect(Collectors.toList());
    }

    public static List<BlockPos> fetchCoveringPositions(ServerLevelAccessor level, BlockPos center, int radius, Predicate<BlockState> statePredicate) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int x = center.getX();
        int z = center.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int verticalRange = 6;
        float limit = Mth.sqrt((float)(radius * radius + radius * radius));
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                int k;
                double theta;
                double noise;
                double threshold;
                int offsetX = x + i;
                int offsetZ = z + j;
                float distance = Mth.sqrt((float)(i * i + j * j));
                if (!((double)distance <= (threshold = (double)(Easing.SINE_IN_OUT.clamped(noise = (COVERING_NOISE.getValue((double)(x * 10000) + (theta = Math.toDegrees(Math.atan2(i, j)) * (double)0.01f), (double)(z * 10000) + theta, true) + 1.0) / 2.0, 0.5, 2.0) * (float)radius * (limit - distance) / limit)))) continue;
                mutable.set(offsetX, center.getY(), offsetZ);
                for (k = 0; k < verticalRange; ++k) {
                    if (level.isStateAtPosition((BlockPos)mutable, statePredicate)) continue;
                    mutable.move(Direction.UP);
                }
                for (k = 0; k <= verticalRange * 2; ++k) {
                    if (!level.isStateAtPosition((BlockPos)mutable, statePredicate)) continue;
                    mutable.move(Direction.DOWN);
                }
                BlockState state = level.getBlockState((BlockPos)mutable);
                if (!state.isFaceSturdy((BlockGetter)level, (BlockPos)mutable, Direction.UP)) continue;
                positions.add(mutable.immutable());
            }
        }
        return positions;
    }

    public static boolean canBeRemoved(BlockState state) {
        return state.canBeReplaced() || state.is(MalumTags.BlockTags.BLIGHT_REMOVABLE);
    }
}

