/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.effect.aqueous;

import com.sammy.malum.common.entity.activator.BlockRiteEffectActivatorEntity;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteBlockEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import team.lodestar.lodestone.helpers.RandomHelper;

public class BlockGrowingRiteEffect
extends SpiritRiteBlockEffect {
    public BlockGrowingRiteEffect() {
        super(SpiritRiteEffectTag.GREATER_RITE);
    }

    @Override
    public void applyEffect(ServerLevel level, BlockRiteEffectActivatorEntity entity, BlockState state, BlockPos pos, float impact) {
        Block block = state.getBlock();
        if (block instanceof FarmBlock) {
            BlockPos abovePos = pos.above();
            BlockState aboveState = level.getBlockState(abovePos);
            if (aboveState.is(BlockTags.CROPS)) {
                int ticks = 2 * Mth.floor((float)impact);
                for (int i = 0; i < ticks; ++i) {
                    aboveState.randomTick(level, abovePos, level.random);
                }
            }
        } else if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            if (!bonemealableBlock.isValidBonemealTarget((LevelReader)level, pos, state)) {
                return;
            }
            if (!bonemealableBlock.isBonemealSuccess((Level)level, level.random, pos, state)) {
                return;
            }
            bonemealableBlock.performBonemeal(level, level.random, pos, state);
        }
        this.createEffect(level, MalumParticleEffectTypes.BLOCK_GROW_RITE_EFFECT, pos, MalumSpiritTypes.AQUEOUS_SPIRIT);
        level.playSound(null, pos, (SoundEvent)MalumSoundEvents.TOTEM_BLOCK_GROW.get(), SoundSource.BLOCKS, 0.5f, RandomHelper.randomBetween((RandomSource)level.random, (float)1.75f, (float)2.0f));
    }
}

