/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.sound;

import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.sound.ExtendedSoundType;

public class BlightedSoundType
extends ExtendedSoundType {
    public BlightedSoundType(float volumeIn, float pitchIn, Supplier<SoundEvent> breakSoundIn, Supplier<SoundEvent> stepSoundIn, Supplier<SoundEvent> placeSoundIn, Supplier<SoundEvent> hitSoundIn, Supplier<SoundEvent> fallSoundIn) {
        super(volumeIn, pitchIn, breakSoundIn, stepSoundIn, placeSoundIn, hitSoundIn, fallSoundIn);
    }

    public void onPlayBreakSound(Level level, BlockPos pos) {
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)MalumSoundEvents.MINOR_BLIGHT_MOTIF.get(), SoundSource.BLOCKS, (this.getVolume() + 1.0f) * 0.15f, this.getPitch() * 1.9f, false);
    }

    public void onPlayStepSound(Level level, BlockPos pos, BlockState state, SoundSource category) {
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)MalumSoundEvents.MINOR_BLIGHT_MOTIF.get(), category, this.getVolume() * 0.1f, this.getPitch() * 1.6f);
    }

    public void onPlayPlaceSound(Level level, BlockPos pos, Player player) {
        level.playSound(player, pos, (SoundEvent)MalumSoundEvents.MINOR_BLIGHT_MOTIF.get(), SoundSource.BLOCKS, (this.getVolume() + 1.0f) * 0.25f, this.getPitch() * 1.8f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPlayHitSound(BlockPos pos) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)MalumSoundEvents.MINOR_BLIGHT_MOTIF.get(), SoundSource.BLOCKS, (this.getVolume() + 1.0f) * 0.05f, this.getPitch() * 2.0f, MalumMod.RANDOM, pos));
    }

    public void onPlayFallSound(Level level, BlockPos pos, SoundSource category) {
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)MalumSoundEvents.MAJOR_BLIGHT_MOTIF.get(), category, this.getVolume() * 0.25f, this.getPitch() * 1.7f);
    }
}

