/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.staff.BoltImpactParticleEffect;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class HexBoltEntity
extends AbstractBoltProjectileEntity {
    public HexBoltEntity(Level level) {
        super((EntityType<? extends AbstractBoltProjectileEntity>)((EntityType)MalumEntities.HEX_BOLT.get()), level);
        this.noPhysics = false;
    }

    public HexBoltEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.setPos(pX, pY, pZ);
        this.noPhysics = false;
    }

    @Override
    public int getMaxAge() {
        return 40;
    }

    @Override
    public BoltImpactParticleEffect getImpactParticleEffect() {
        return MalumParticleEffectTypes.HEX_BOLT_IMPACT;
    }

    @Override
    public MalumNetworkedParticleEffectColorData getImpactParticleColor() {
        return new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.WICKED_SPIRIT);
    }

    protected Item getDefaultItem() {
        return (Item)MalumItems.MNEMONIC_HEX_STAFF.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.level();
        Vec3 position = this.position();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, position, MalumSpiritTypes.WICKED_SPIRIT);
        lightSpecs.getBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.spawnParticles();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)this.random, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.5f)).randomSpinOffset(this.random).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        WorldParticleBuilder.create(MalumParticles.SAW).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)this.getDeltaMovement().normalize())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.9f * scalar), (float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.4f * scalar), (float)(0.3f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.WICKED_SPIRIT.createColorData().build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(Math.min(6 + this.age * 3, 30)).addTickActor(behavior).setSpinData((SpinParticleDataWrapper)spinData).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.5f * scalar), (float)(0.3f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)ColorHelper.darker((Color)MalumSpiritTypes.WICKED_SPIRIT.getPrimaryColor(), (int)2)).build()).spawn(level, position.x, position.y, position.z);
    }
}

