/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.sammy.malum.common.entity.FloatingItemDestinationData;
import com.sammy.malum.common.entity.MovingEntity;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class FloatingEntity
extends MovingEntity {
    public final TrailPointBuilder trail = TrailPointBuilder.create((int)5);
    public final TrailPointBuilder longTrail = TrailPointBuilder.create((int)30);
    protected FloatingItemDestinationData destination;
    protected float hoverOffset;
    protected int age;
    protected int maxAge;
    protected int movementWindUp;
    protected int hoverWindUp;

    public FloatingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = false;
        this.hoverOffset = (float)(Math.random() * Math.PI * 2.0);
    }

    public abstract void collect(ServerLevel var1);

    public boolean shouldVanishAfterCollection(ServerLevel level) {
        return true;
    }

    public void setDestination(FloatingItemDestinationData destination) {
        this.destination = destination;
    }

    public FloatingItemDestinationData getDestination() {
        return this.destination;
    }

    public float getVisualEffectScalar() {
        return Math.min((float)this.age / 5.0f, 1.0f);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.destination = FloatingItemDestinationData.load(compound);
        this.age = compound.getInt("age");
        this.maxAge = compound.getInt("maxAge");
        this.movementWindUp = compound.getInt("movementWindUp");
        this.hoverWindUp = compound.getInt("hoverWindUp");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.destination != null) {
            this.destination.save(compound);
        }
        compound.putInt("age", this.age);
        compound.putInt("maxAge", this.maxAge);
        compound.putInt("movementWindUp", this.movementWindUp);
        compound.putInt("hoverWindUp", this.hoverWindUp);
    }

    @Override
    public void tick() {
        if (this.age > this.maxAge) {
            this.discard();
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.destination != null && this.destination.isValid(level2)) {
                float distance = (float)this.destination.getDistance(level2, this);
                Optional<Vec3> destination = this.destination.getDestination(level2);
                if (destination.isPresent()) {
                    float windUpDuration = this.getWindUpDuration();
                    Vec3 targetPos = destination.get();
                    if ((float)this.movementWindUp < windUpDuration) {
                        ++this.movementWindUp;
                    }
                    float delta = Mth.clamp((float)((float)this.movementWindUp / windUpDuration), (float)0.0f, (float)1.0f);
                    float velocity = Mth.clamp((float)(delta - 0.25f), (float)0.0f, (float)0.75f) * this.getMovementSpeed(delta, distance);
                    float easing = this.getMovementEasing(delta, distance);
                    Vec3 targetMovement = targetPos.subtract(this.position()).normalize().scale((double)velocity);
                    Vec3 newMovement = this.getDeltaMovement().lerp(targetMovement, (double)easing);
                    this.setDeltaMovement(newMovement);
                    if (distance < 0.4f) {
                        boolean shouldVanish = this.shouldVanishAfterCollection(level2);
                        this.collect(level2);
                        if (shouldVanish) {
                            this.remove(Entity.RemovalReason.DISCARDED);
                        }
                    }
                }
            } else {
                if (this.movementWindUp > 0) {
                    --this.movementWindUp;
                }
                if (this.age >= 40) {
                    float windUpDuration = this.getWindUpDuration();
                    float gravity = 0.004f * (windUpDuration - (float)this.movementWindUp) / windUpDuration;
                    this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, (double)gravity, 0.0).multiply((double)0.9f, (double)0.96f, (double)0.9f));
                }
                if (level2.getGameTime() % 20L == 0L) {
                    ServerPlayer nearestPlayer = null;
                    float minimumDistance = 6.0f;
                    for (ServerPlayer player : level2.players()) {
                        float distance = player.distanceTo((Entity)this);
                        if (!(distance < minimumDistance) || !player.hasLineOfSight((Entity)this)) continue;
                        nearestPlayer = player;
                        minimumDistance = distance;
                    }
                    if (nearestPlayer != null && nearestPlayer.isAlive()) {
                        this.setDestination(new FloatingItemDestinationData(nearestPlayer.getUUID()));
                    }
                }
            }
        } else {
            Vec3 position = this.getOffsetPosition(0.5f);
            this.trail.addTrailPoint(position);
            this.longTrail.addTrailPoint(position);
            this.trail.tickTrailPoints();
            this.longTrail.tickTrailPoints();
        }
        super.tick();
        ++this.age;
    }

    @Override
    public float getFriction() {
        return 0.96f;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    public int getWindUpDuration() {
        return 50;
    }

    public float getMovementSpeed(float windUp, float distance) {
        return 3.0f;
    }

    public float getMovementEasing(float windUp, float distance) {
        float windUpScalar = windUp * 0.01f;
        float distanceScalar = 1.0f / Math.max(distance, 1.0f) * 0.025f;
        return windUpScalar + distanceScalar;
    }

    public Vec3 getOffsetPosition() {
        return this.getOffsetPosition(0.0f);
    }

    public Vec3 getOffsetPosition(float partialTicks) {
        return this.getPosition(partialTicks).add(0.0, (double)this.getYOffset(0.0f), 0.0);
    }

    public float getYOffset(float partialTicks) {
        float windUpDuration = this.getWindUpDuration();
        float offsetStrength = Easing.CIRC_IN_OUT.clamped(((float)this.age + partialTicks) / windUpDuration, 0.0f, 1.0f);
        return Mth.sin((float)(((float)this.age + partialTicks) / 6.0f + this.hoverOffset)) * (0.5f - offsetStrength * 0.25f);
    }

    public float getRotation(float partialTicks) {
        return ((float)this.age + partialTicks) / 10.0f + this.hoverOffset;
    }
}

