/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.component.pouch;

import com.sammy.malum.common.data.component.pouch.RavenousPouchContentsComponent;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public abstract class PouchContentsWeightProcessor {
    protected static final Fraction POUCH_IN_POUCH_WEIGHT = Fraction.getFraction((int)1, (int)16);

    public Fraction computeContentWeight(List<ItemStack> content) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemstack : content) {
            fraction = fraction.add(this.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.getCount(), (int)1)));
        }
        return fraction;
    }

    public Fraction getWeight(ItemStack stack) {
        RavenousPouchContentsComponent contents = (RavenousPouchContentsComponent)stack.get(MalumDataComponents.RAVENOUS_POUCH_CONTENTS);
        if (contents != null) {
            return POUCH_IN_POUCH_WEIGHT.add(contents.weight());
        }
        return Fraction.getFraction((int)1, (int)(stack.getMaxStackSize() * this.getWeightModifier(stack)));
    }

    public abstract int getWeightModifier(ItemStack var1);
}

