/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.component.pouch;

import com.google.common.collect.Lists;
import com.sammy.malum.common.data.component.pouch.PouchContentsWeightProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.math.Fraction;

public abstract class MalumPouchContentsComponent
implements TooltipComponent {
    final List<ItemStack> items;
    final Fraction weight;

    MalumPouchContentsComponent(List<ItemStack> items, Fraction weight) {
        this.items = items;
        this.weight = weight;
    }

    public MalumPouchContentsComponent(List<ItemStack> items, PouchContentsWeightProcessor processor) {
        this(items, processor.computeContentWeight(items));
    }

    public abstract Mutable mutable();

    public abstract int getStorageSize();

    public ItemStack getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public boolean containsItem(ItemLike item) {
        for (ItemStack stack : this.items) {
            if (!stack.is(item.asItem())) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getItemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MalumPouchContentsComponent)) return false;
        MalumPouchContentsComponent otherContents = (MalumPouchContentsComponent)other;
        if (!this.weight.equals((Object)otherContents.weight)) return false;
        if (!ItemStack.listMatches(this.items, otherContents.items)) return false;
        return true;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "PouchContents" + String.valueOf(this.items);
    }

    public static abstract class Mutable {
        protected final List<ItemStack> items;
        protected final PouchContentsWeightProcessor processor;
        protected Fraction weight;

        public Mutable(MalumPouchContentsComponent contents, PouchContentsWeightProcessor processor) {
            this.items = new ArrayList<ItemStack>(contents.items);
            this.processor = processor;
            this.weight = contents.weight;
        }

        public abstract MalumPouchContentsComponent immutable();

        public List<ItemStack> getItems() {
            return this.items;
        }

        public void clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
        }

        private int findStackIndex(ItemStack stack) {
            if (stack.isStackable()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack compare = this.items.get(i);
                    if (compare.getCount() >= compare.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)compare, (ItemStack)stack)) continue;
                    return i;
                }
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack stack) {
            Fraction fraction = Fraction.ONE.subtract(this.weight);
            return Math.max(fraction.divideBy(this.processor.getWeight(stack)).intValue(), 0);
        }

        public int tryTransfer(Slot slot, Player player) {
            ItemStack itemstack = slot.getItem();
            int i = this.getMaxAmountToAdd(itemstack);
            return this.tryInsert(slot.safeTake(itemstack.getCount(), i, player));
        }

        public int tryInsert(ItemStack stack) {
            if (!stack.isEmpty() && stack.getItem().canFitInsideContainerItems()) {
                int i = Math.min(stack.getCount(), this.getMaxAmountToAdd(stack));
                if (i == 0) {
                    return 0;
                }
                this.weight = this.weight.add(this.processor.getWeight(stack).multiplyBy(Fraction.getFraction((int)i, (int)1)));
                int j = this.findStackIndex(stack);
                if (j != -1) {
                    ItemStack itemstack = this.items.remove(j);
                    int transferSize = Math.min(i, stack.getMaxStackSize() - itemstack.getCount());
                    this.addItem(itemstack.copyWithCount(itemstack.getCount() + transferSize));
                    stack.shrink(transferSize);
                    if (!stack.isEmpty()) {
                        int remainder = stack.getCount();
                        this.weight = this.weight.add(this.processor.getWeight(stack).multiplyBy(Fraction.getFraction((int)remainder, (int)1)));
                        this.items.addFirst(itemstack.copyWithCount(remainder));
                        stack.shrink(remainder);
                    }
                } else {
                    this.items.addFirst(stack.split(i));
                }
                return i;
            }
            return 0;
        }

        public void addItem(ItemStack stack) {
            this.items.addFirst(stack);
        }

        public boolean containsItem(ItemLike item) {
            for (ItemStack stack : this.items) {
                if (!stack.is(item.asItem())) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            ItemStack itemstack = this.items.removeFirst().copy();
            this.weight = this.weight.subtract(this.processor.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.getCount(), (int)1)));
            return itemstack;
        }

        public Fraction weight() {
            return this.weight;
        }
    }
}

