/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record ItemSkinComponent(ResourceLocation name, int id) {
    public static Codec<ItemSkinComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("name").forGetter(ItemSkinComponent::name), (App)Codec.INT.fieldOf("id").forGetter(ItemSkinComponent::id)).apply((Applicative)instance, ItemSkinComponent::new));
    public static StreamCodec<ByteBuf, ItemSkinComponent> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    public static final List<ItemSkinComponent> REGISTERED_SKINS = new ArrayList<ItemSkinComponent>();
    public static final ItemSkinComponent ACE = ItemSkinComponent.register("ace");
    public static final ItemSkinComponent AGENDER = ItemSkinComponent.register("agender");
    public static final ItemSkinComponent ARO = ItemSkinComponent.register("aro");
    public static final ItemSkinComponent AROACE = ItemSkinComponent.register("aroace");
    public static final ItemSkinComponent BI = ItemSkinComponent.register("bi");
    public static final ItemSkinComponent DEMIBOY = ItemSkinComponent.register("demiboy");
    public static final ItemSkinComponent DEMIGIRL = ItemSkinComponent.register("demigirl");
    public static final ItemSkinComponent ENBY = ItemSkinComponent.register("enby");
    public static final ItemSkinComponent GAY = ItemSkinComponent.register("gay");
    public static final ItemSkinComponent GENDERFLUID = ItemSkinComponent.register("genderfluid");
    public static final ItemSkinComponent GENDERQUEER = ItemSkinComponent.register("genderqueer");
    public static final ItemSkinComponent INTERSEX = ItemSkinComponent.register("intersex");
    public static final ItemSkinComponent LESBIAN = ItemSkinComponent.register("lesbian");
    public static final ItemSkinComponent PAN = ItemSkinComponent.register("pan");
    public static final ItemSkinComponent PLURAL = ItemSkinComponent.register("plural");
    public static final ItemSkinComponent POLY = ItemSkinComponent.register("poly");
    public static final ItemSkinComponent PRIDE = ItemSkinComponent.register("pride");
    public static final ItemSkinComponent TRANS = ItemSkinComponent.register("trans");
    public static final ItemSkinComponent BLUE_MACHINE = ItemSkinComponent.register("v1");
    public static final ItemSkinComponent RED_MACHINE = ItemSkinComponent.register("v2");
    public static final ItemSkinComponent COMMANDO = ItemSkinComponent.register("commando");
    public static final ItemSkinComponent ANCIENT_CLOTH = ItemSkinComponent.register("ancient_soul_hunter");
    public static final ItemSkinComponent ANCIENT_METAL = ItemSkinComponent.register("ancient_soul_stained_steel");

    public static ItemSkinComponent register(String name) {
        return ItemSkinComponent.register(MalumMod.malumPath(name));
    }

    public static ItemSkinComponent register(ResourceLocation name) {
        ItemSkinComponent pattern = new ItemSkinComponent(name, REGISTERED_SKINS.size());
        REGISTERED_SKINS.add(pattern);
        return pattern;
    }

    public static int getSkinId(ItemStack stack) {
        if (!stack.has(MalumDataComponents.ITEM_SKIN)) {
            return -1;
        }
        return ((ItemSkinComponent)stack.get((DataComponentType)((DataComponentType)MalumDataComponents.ITEM_SKIN.get()))).id;
    }

    public static int getAppliedSkinId(ItemStack stack) {
        if (!stack.has(MalumDataComponents.APPLIED_ITEM_SKIN)) {
            return -1;
        }
        return ((ItemSkinComponent)stack.get((DataComponentType)((DataComponentType)MalumDataComponents.APPLIED_ITEM_SKIN.get()))).id;
    }
}

