/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.geas.pact.infernal.ProspectorGeas;
import com.sammy.malum.common.item.curiosities.curios.sets.prospector.CurioProspectorBelt;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.magic.MalumGeasEffectTypes;
import com.sammy.malum.visual_effects.AvariceParticleEffects;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class AvariceMarkData {
    public static Codec<AvariceMarkData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)Codec.BOOL.optionalFieldOf("hasProspectorMark", (Object)false).forGetter(AvariceMarkData::hasAvariceMark), (App)Codec.INT.optionalFieldOf("carriedAvarice", (Object)0).forGetter(AvariceMarkData::getCarriedAvarice)).apply((Applicative)obj, AvariceMarkData::new));
    public static StreamCodec<ByteBuf, AvariceMarkData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private boolean hasAvariceMark;
    private int carriedAvarice;

    private AvariceMarkData(boolean hasAvariceMark, int carriedAvarice) {
        this.hasAvariceMark = hasAvariceMark;
    }

    public AvariceMarkData() {
    }

    public boolean hasAvariceMark() {
        return this.hasAvariceMark;
    }

    public int getCarriedAvarice() {
        return this.carriedAvarice;
    }

    public static void applyAvariceMark(BlockDropsEvent event) {
        LivingEntity breaker;
        int amount;
        Entity entity = event.getBreaker();
        if (entity instanceof LivingEntity && (amount = AvariceMarkData.getAppliedAvarice(breaker = (LivingEntity)entity)) > 0) {
            for (ItemEntity drop : event.getDrops()) {
                AvariceMarkData.tryMarkEntity(drop, amount);
            }
        }
    }

    public static int getAppliedAvarice(LivingEntity entity) {
        int amount;
        boolean hasPact = ProspectorGeas.hasProspectorPact(entity);
        boolean hasBelt = CurioProspectorBelt.hasProspectorBelt(entity);
        int n = amount = hasPact ? 1 : 0;
        if (hasBelt && entity.getRandom().nextFloat() < 0.5f) {
            ++amount;
        }
        return amount;
    }

    public void tickData(Entity entity) {
        if (entity.level().isClientSide) {
            AvariceParticleEffects.avariceItemParticles(entity.level(), entity);
        }
    }

    public void enableMark(int amount) {
        this.hasAvariceMark = true;
        this.carriedAvarice = amount;
    }

    public static void entityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        entity.getExistingData(MalumAttachmentTypes.AVARICE_MARK).ifPresent(d -> d.tickData(entity));
    }

    public static void pickupItem(ItemEntityPickupEvent.Post event) {
        ItemEntity entity = event.getItemEntity();
        entity.getExistingData(MalumAttachmentTypes.AVARICE_MARK).ifPresent(data -> {
            if (data.hasAvariceMark()) {
                AvariceMarkData.applyAvarice((LivingEntity)event.getPlayer(), data.carriedAvarice * event.getOriginalStack().getCount());
            }
        });
    }

    public static void popResourceAndMarkEntity(Level level, BlockPos pos, ItemStack stack, int amount) {
        double d0 = (double)EntityType.ITEM.getHeight() / 2.0;
        double d1 = (double)pos.getX() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
        double d2 = (double)pos.getY() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pos.getZ() + 0.5 + Mth.nextDouble((RandomSource)level.random, (double)-0.25, (double)0.25);
        Block.popResource((Level)level, () -> AvariceMarkData.tryMarkEntity(new ItemEntity(level, d1, d2, d3, stack), amount), (ItemStack)stack);
    }

    public static ItemEntity tryMarkEntity(ItemEntity entity, int amount) {
        if (entity.getItem().is(MalumTags.ItemTags.PROSPECTORS_TREASURE)) {
            ((AvariceMarkData)entity.getData(MalumAttachmentTypes.AVARICE_MARK)).enableMark(amount);
            entity.syncData(MalumAttachmentTypes.AVARICE_MARK);
        }
        return entity;
    }

    public static void applyAvarice(LivingEntity target, int amount) {
        DeferredHolder<MobEffect, MobEffect> effect = MalumMobEffects.AVARICE;
        MobEffectInstance instance = target.getEffect(effect);
        float volume = 1.0f;
        if (instance == null) {
            target.addEffect(new MobEffectInstance(effect, 400, amount - 1, true, true, true));
        } else {
            EntityHelper.amplifyEffect((MobEffectInstance)instance, (LivingEntity)target, (int)amount, (int)9);
            EntityHelper.extendEffect((MobEffectInstance)instance, (LivingEntity)target, (int)400, (int)2400);
            volume -= Math.min((float)instance.getAmplifier() * 0.05f, 0.5f);
        }
        if (GeasEffectHandler.hasGeasEffect(target, MalumGeasEffectTypes.PACT_OF_THE_PROSPECTOR)) {
            target.heal((float)(amount * 2));
        }
        SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.AVARICE_COLLECT.get()), (float)volume, (float)(0.8f + target.getRandom().nextFloat() * 0.4f));
    }
}

