/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.blockentity.ItemHolderBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;

public abstract class MalumItemHolderBlockEntity
extends ItemHolderBlockEntity
implements IMalumSpecialItemAccessPoint {
    public MalumItemHolderBlockEntity(BlockEntityType<? extends MalumItemHolderBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = MalumBlockEntityInventory.singleItemStack((LodestoneBlockEntity)this);
    }

    @Override
    public LodestoneBlockEntityInventory getSuppliedInventory() {
        return this.inventory;
    }

    @Override
    public Vec3 getItemPos(float partialTicks) {
        BlockPos blockPos = this.getBlockPos();
        Vec3 offset = this.getItemOffset(partialTicks);
        return new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
    }

    @Override
    public BlockPos getAccessPointBlockPos() {
        return this.worldPosition;
    }

    public void tick() {
        Item item;
        if (this.level.isClientSide && (item = this.inventory.getStackInSlot(0).getItem()) instanceof SpiritShardItem) {
            SpiritShardItem item2 = (SpiritShardItem)item;
            SpiritLightSpecs.rotatingLightSpecs(this.level, this.getItemPos(), item2, 0.4f, 2);
        }
    }

    public abstract Vec3 getItemOffset(float var1);
}

